/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.tree;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.world.feature.tree.TemplateTreeFeature;
import com.mushroom.midnight.common.world.template.ShelfAttachProcessor;
import com.mushroom.midnight.common.world.template.TemplateCompiler;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LargeBogshroomFeature
extends TemplateTreeFeature {
    private static final ResourceLocation[] TEMPLATES = new ResourceLocation[]{new ResourceLocation("midnight", "mushroom/bogshroom_large")};
    private static final BlockState STEM = MidnightBlocks.BOGSHROOM_STEM.func_176223_P();
    private static final BlockState HAT = MidnightBlocks.BOGSHROOM_HAT.func_176223_P();

    public LargeBogshroomFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize, TEMPLATES, STEM, HAT);
    }

    @Override
    protected TemplateCompiler buildCompiler() {
        return super.buildCompiler().withPostProcessor(new ShelfAttachProcessor(this::canPlaceShelf, ShelfAttachProcessor.SHELF_BLOCKS));
    }

    private boolean canPlaceShelf(IWorld world, BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MidnightBlocks.FUNGI_INSIDE) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || state.func_203425_a(BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151585_k;
    }
}

