/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.structure;

import com.mushroom.midnight.common.registry.MidnightLootTables;
import com.mushroom.midnight.common.registry.MidnightStructurePieces;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class ShadowrootGuardTowerPieces {
    private static final ResourceLocation LOCATION = new ResourceLocation("midnight", "shadowroot_guardtower");

    public static void addTowerPieces(TemplateManager templateManager, BlockPos origin, Rotation rotation, List<StructurePiece> pieces) {
        pieces.add((StructurePiece)new Piece(templateManager, LOCATION, origin, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation templateLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation templateLocation, BlockPos position, Rotation rotation) {
            super(MidnightStructurePieces.SHADOWROOT_GUARDTOWER, 0);
            this.templateLocation = templateLocation;
            this.field_186178_c = position;
            this.rotation = rotation;
            this.setup(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT compound) {
            super(MidnightStructurePieces.SHADOWROOT_GUARDTOWER, compound);
            this.templateLocation = new ResourceLocation(compound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        private void setup(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.templateLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT compound) {
            super.func_143011_b(compound);
            compound.func_74778_a("Template", this.templateLocation.toString());
            compound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(MidnightLootTables.LOOT_TABLE_SHADOWROOT_GUARDTOWER, rand.nextLong());
                }
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox bounds, ChunkPos chunkPos) {
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            BlockPos origin = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(5, 0, 3)));
            int height = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, origin.func_177958_n(), origin.func_177952_p());
            BlockPos templateOrigin = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, height - 90 - 1, 0);
            boolean result = super.func_225577_a_(world, p_225577_2_, random, bounds, chunkPos);
            this.field_186178_c = templateOrigin;
            return result;
        }
    }
}

