/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightFluids;
import com.mushroom.midnight.common.registry.MidnightStructurePieces;
import com.mushroom.midnight.common.registry.MidnightTags;
import com.mushroom.midnight.common.world.noise.INoiseSampler;
import com.mushroom.midnight.common.world.noise.PerlinNoiseSampler;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public final class MoltenCraterStructure
extends Structure<NoFeatureConfig> {
    private static final int SEED = 10245583;
    private static final int GRID_SIZE = 20;
    private static final int SEPARATION = 8;
    private static final int MIN_RADIUS = 16;
    private static final int MAX_RADIUS = 42;
    private static final int MAX_GENERATION_Y = 86;
    private static final int SCALE_Y = 2;
    private static final int EDGE_DEPTH = 12;
    private static final int POOL_DEPTH = 3;
    private static final int FULL_RADIUS = 54;
    private static final int CHUNK_RADIUS = MathHelper.func_76143_f((double)3.375);
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState MIASMA = MidnightBlocks.MIASMA.func_176223_P();
    private static final BlockState MIASMA_SURFACE = MidnightBlocks.MIASMA_SURFACE.func_176223_P();
    private static final BlockState SURFACE = MidnightBlocks.TRENCHSTONE.func_176223_P();
    private static final INoiseSampler NOISE_SAMPLER = new PerlinNoiseSampler(new Random(10245583L));
    public static final String NAME = "midnight:molten_crater";

    public MoltenCraterStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> generator, Random random, int chunkX, int chunkZ, int offsetX, int offsetZ) {
        int ox = chunkX + 20 * offsetX;
        int oz = chunkZ + 20 * offsetZ;
        int gridX = (ox < 0 ? ox - 20 + 1 : ox) / 20;
        int gridZ = (oz < 0 ? oz - 20 + 1 : oz) / 20;
        ((SharedSeedRandom)random).func_202427_a(generator.func_202089_c(), gridX, gridZ, 10245583);
        int startX = gridX * 20;
        int startZ = gridZ * 20;
        return new ChunkPos(startX += random.nextInt(12), startZ += random.nextInt(12));
    }

    public boolean func_225558_a_(BiomeManager biomeMgr, ChunkGenerator<?> generator, Random random, int chunkX, int chunkZ, Biome unusedBiomeVariableThatWeCantCallBiomeBecauseThatNameAlreadyExists) {
        int config = (Integer)MidnightConfig.worldgen.guardtowerStructureRarity.get();
        if (config == 0) {
            return false;
        }
        ChunkPos startPos = this.func_211744_a(generator, random, chunkX, chunkZ, 0, 0);
        if (chunkX == startPos.field_77276_a && chunkZ == startPos.field_77275_b) {
            Metadata metadata;
            SharedSeedRandom seedRandom = (SharedSeedRandom)random;
            seedRandom.func_202425_c(generator.func_202089_c(), chunkX, chunkZ);
            if (seedRandom.nextInt(config) == 0 && (metadata = Metadata.generate(seedRandom, generator, chunkX, chunkZ)).isValid()) {
                BiomeProvider biomeProvider = generator.func_202090_b();
                return biomeProvider.func_225530_a_((chunkX << 4) + 9, 0, (chunkZ << 4) + 9, metadata.radius).stream().allMatch(biome -> generator.func_202094_a(biome, (Structure)this));
            }
        }
        return false;
    }

    @Nullable
    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos pos, int radius, boolean skipExistingChunks) {
        int config = (Integer)MidnightConfig.worldgen.moltenCraterStructureRarity.get();
        if (config == 0) {
            return null;
        }
        return super.func_211405_a(world, chunkGenerator, pos, radius, skipExistingChunks);
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return CHUNK_RADIUS;
    }

    static {
        NOISE_SAMPLER.setFrequency(0.001);
    }

    public static class Piece
    extends StructurePiece {
        private Metadata metadata;

        Piece(Metadata metadata) {
            super(MidnightStructurePieces.MOLTEN_CRATER, 0);
            this.metadata = metadata;
            this.initBounds();
        }

        public Piece(TemplateManager templateManager, CompoundNBT compound) {
            super(MidnightStructurePieces.MOLTEN_CRATER, compound);
            this.metadata = Metadata.deserialize(compound);
            this.initBounds();
        }

        private void initBounds() {
            int fullRadius = this.metadata.radius + 12;
            this.field_74887_e = new MutableBoundingBox(this.metadata.originX - fullRadius, this.metadata.originY - fullRadius / 2, this.metadata.originZ - fullRadius, this.metadata.originX + fullRadius, this.metadata.originY + fullRadius / 2, this.metadata.originZ + fullRadius);
        }

        protected void func_143011_b(CompoundNBT compound) {
            this.metadata.serialize(compound);
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> p_225577_2_, Random random, MutableBoundingBox bounds, ChunkPos chunkPos) {
            int minX = Math.max(this.field_74887_e.field_78897_a, bounds.field_78897_a);
            int maxX = Math.min(this.field_74887_e.field_78893_d, bounds.field_78893_d);
            int minZ = Math.max(this.field_74887_e.field_78896_c, bounds.field_78896_c);
            int maxZ = Math.min(this.field_74887_e.field_78892_f, bounds.field_78892_f);
            int minY = Math.max(this.field_74887_e.field_78895_b, 0);
            int maxY = Math.min(this.field_74887_e.field_78894_e, 255);
            if (minX >= maxX || minZ >= maxZ || minY >= maxY) {
                return true;
            }
            BlockPos minPos = new BlockPos(minX, minY, minZ);
            BlockPos maxPos = new BlockPos(maxX, maxY, maxZ);
            this.carveCrater(world, minPos, maxPos);
            this.decorateSurface(world, random, minPos, maxPos);
            return true;
        }

        private void carveCrater(IWorld world, BlockPos minPos, BlockPos maxPos) {
            int edgeRadius = this.metadata.radius + 12;
            int radiusSquared = this.metadata.radius * this.metadata.radius;
            int edgeRadiusSquared = edgeRadius * edgeRadius;
            int poolLevel = this.metadata.originY - this.metadata.radius / 2 + 3;
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minPos, (BlockPos)maxPos)) {
                double noise = (NOISE_SAMPLER.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) + 1.0) * 8.0;
                double distanceSquared = this.computeDistanceToCenterSquared(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) + noise * noise;
                if (!(distanceSquared <= (double)edgeRadiusSquared)) continue;
                if (distanceSquared < (double)radiusSquared) {
                    this.carveCraterBlock(world, poolLevel, pos);
                    continue;
                }
                this.hardenEdgeBlock(world, pos);
            }
        }

        private void carveCraterBlock(IWorld world, int poolLevel, BlockPos pos) {
            if (world.func_180495_p(pos) == AIR) {
                return;
            }
            if (pos.func_177956_o() <= poolLevel) {
                world.func_180501_a(pos, MIASMA, 2);
            } else {
                world.func_180501_a(pos, AIR, 2);
            }
        }

        private boolean canHarden(BlockState state) {
            if (state.func_203425_a(MidnightTags.Blocks.FUNGI_HATS)) {
                return false;
            }
            if (state.func_203425_a(MidnightTags.Blocks.FUNGI_STEMS)) {
                return false;
            }
            if (state.func_203425_a(MidnightTags.Blocks.LOGS)) {
                return false;
            }
            if (!state.func_200132_m()) {
                return false;
            }
            Material mat = state.func_185904_a();
            return mat == Material.field_151576_e || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151571_B || mat == Material.field_151577_b;
        }

        private void hardenEdgeBlock(IWorld world, BlockPos pos) {
            BlockState currentState = world.func_180495_p(pos);
            if (this.canHarden(currentState)) {
                world.func_180501_a(pos, SURFACE, 2);
            }
        }

        private void decorateSurface(IWorld world, Random random, BlockPos minPos, BlockPos maxPos) {
            int edgeRadius = this.metadata.radius + 12;
            int edgeRadiusSquared = edgeRadius * edgeRadius;
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            for (int z = minPos.func_177952_p(); z <= maxPos.func_177952_p(); ++z) {
                for (int x = minPos.func_177958_n(); x <= maxPos.func_177958_n(); ++x) {
                    BlockState state;
                    int deltaX = x - this.metadata.originX;
                    int deltaZ = z - this.metadata.originZ;
                    int distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (distanceSquared > edgeRadiusSquared) continue;
                    int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z) - 1;
                    mutablePos.func_181079_c(x, y, z);
                    if (world.func_180495_p((BlockPos)mutablePos) != SURFACE || (state = this.selectSurfaceState(random)) == null) continue;
                    world.func_180501_a((BlockPos)mutablePos, state, 2);
                    if (state != MIASMA) continue;
                    world.func_205219_F_().func_205360_a((BlockPos)mutablePos, (Object)MidnightFluids.MIASMA, 0);
                }
            }
        }

        @Nullable
        private BlockState selectSurfaceState(Random random) {
            float value = random.nextFloat();
            if (value > 0.95f) {
                return MIASMA;
            }
            if (value > 0.7f) {
                return MIASMA_SURFACE;
            }
            return null;
        }

        private double computeDistanceToCenterSquared(int x, int y, int z) {
            int deltaX = x - this.metadata.originX;
            int deltaY = Math.min(y - this.metadata.originY, 0) * 2;
            int deltaZ = z - this.metadata.originZ;
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }

    public static class Start
    extends StructureStart {
        Start(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox bounds, int reference, long seed) {
            super(structure, chunkX, chunkZ, bounds, reference, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome) {
            Metadata metadata = Metadata.generate(this.field_214631_d, generator, chunkX, chunkZ);
            this.field_75075_a.add(new Piece(metadata));
            this.func_202500_a();
        }
    }

    private static class Metadata {
        final int originX;
        final int originY;
        final int originZ;
        final int radius;

        Metadata(int originX, int originY, int originZ, int radius) {
            this.originX = originX;
            this.originY = originY;
            this.originZ = originZ;
            this.radius = radius;
        }

        static Metadata generate(SharedSeedRandom random, ChunkGenerator<?> generator, int chunkX, int chunkZ) {
            int originX = (chunkX << 4) + random.nextInt(16);
            int originZ = (chunkZ << 4) + random.nextInt(16);
            int originY = generator.func_222531_c(originX, originZ, Heightmap.Type.WORLD_SURFACE_WG);
            int radius = random.nextInt(27) + 16;
            return new Metadata(originX, originY, originZ, radius);
        }

        boolean isValid() {
            return this.originY < 86;
        }

        CompoundNBT serialize(CompoundNBT compound) {
            compound.func_74768_a("origin_x", this.originX);
            compound.func_74768_a("origin_y", this.originY);
            compound.func_74768_a("origin_z", this.originZ);
            compound.func_74768_a("radius", this.radius);
            return compound;
        }

        static Metadata deserialize(CompoundNBT compound) {
            int originX = compound.func_74762_e("origin_x");
            int originY = compound.func_74762_e("origin_y");
            int originZ = compound.func_74762_e("origin_z");
            int radius = compound.func_74762_e("radius");
            return new Metadata(originX, originY, originZ, radius);
        }
    }
}

