/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.world.MidnightChunkGenerator;
import com.mushroom.midnight.common.world.feature.structure.EntranceRiftPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EntranceRiftStructure
extends ScatteredStructure<NoFeatureConfig> {
    public EntranceRiftStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51491_1_) {
        super(p_i51491_1_);
    }

    public String func_143025_a() {
        return "midnight:entrance_rift";
    }

    public int func_202367_b() {
        return 3;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected int func_202382_c() {
        return 14357618;
    }

    public boolean func_225558_a_(BiomeManager biomeMgr, ChunkGenerator<?> chunkGen, Random rand, int cx, int cz, Biome biome) {
        ChunkPos start = this.func_211744_a(chunkGen, rand, cx, cz, 0, 0);
        IWorld world = (IWorld)ObfuscationReflectionHelper.getPrivateValue(ChunkGenerator.class, chunkGen, (String)"field_222540_a");
        if (world != null && (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ || chunkGen instanceof MidnightChunkGenerator) && cx == start.field_77276_a && cz == start.field_77275_b) {
            int rx = cx >> 4;
            int rz = cz >> 4;
            rand.setSeed((long)(rx ^ rz << 4) ^ chunkGen.func_202089_c());
            rand.nextInt();
            int config = (Integer)MidnightConfig.worldgen.riftStructureRarity.get();
            if (config <= 0 || rand.nextInt(config) != 0) {
                return false;
            }
            if (MidnightConfig.getRiftBiomes().contains(biome) && MidnightConfig.getRiftDims().contains(world.func_201675_m().func_186058_p())) {
                for (int k = cx - 10; k <= cx + 10; ++k) {
                    for (int l = cz - 10; l <= cz + 10; ++l) {
                        if (!Feature.field_214550_p.func_225558_a_(biomeMgr, chunkGen, rand, k, l, biomeMgr.func_226836_a_(new BlockPos((k << 4) + 9, 0, (l << 4) + 9)))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGen, BlockPos pos, int radius, boolean skipExistingChunks) {
        int config = (Integer)MidnightConfig.worldgen.riftStructureRarity.get();
        if (config == 0) {
            return null;
        }
        if (!MidnightConfig.getRiftDims().contains(world.func_201675_m().func_186058_p())) {
            return null;
        }
        if (!chunkGen.func_202090_b().func_205004_a((Structure)this)) {
            return null;
        }
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        SharedSeedRandom rand = new SharedSeedRandom();
        block0: for (int rad = 0; rad <= radius; ++rad) {
            for (int xOff = -rad; xOff <= rad; ++xOff) {
                boolean xEdge = xOff == -rad || xOff == rad;
                for (int zOff = -rad; zOff <= rad; ++zOff) {
                    boolean zEdge;
                    boolean bl = zEdge = zOff == -rad || zOff == rad;
                    if (!xEdge && !zEdge) continue;
                    ChunkPos cpos = this.func_211744_a(chunkGen, (Random)rand, cx, cz, xOff, zOff);
                    boolean startAtPos = this.func_225558_a_(world.func_225523_d_(), chunkGen, (Random)rand, cpos.field_77276_a, cpos.field_77275_b, world.func_226691_t_(new BlockPos((cpos.field_77276_a << 4) + 9, 64, (cpos.field_77275_b << 4) + 9)));
                    if (startAtPos) {
                        return new BlockPos((cpos.field_77276_a << 4) + 9, 64, (cpos.field_77275_b << 4) + 9);
                    }
                    if (rad == 0) break;
                }
                if (rad == 0) continue block0;
            }
        }
        return null;
    }

    protected int func_204030_a(ChunkGenerator<?> generator) {
        return 24;
    }

    protected int func_211745_b(ChunkGenerator<?> generator) {
        return 3;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> p_i50678_1_, int p_i50678_2_, int p_i50678_3_, MutableBoundingBox p_i50678_5_, int p_i50678_6_, long p_i50678_7_) {
            super(p_i50678_1_, p_i50678_2_, p_i50678_3_, p_i50678_5_, p_i50678_6_, p_i50678_7_);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int i = chunkX * 16;
            int j = chunkZ * 16;
            int originY = generator.func_222531_c(i, j, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(i, originY, j);
            EntranceRiftPieces.addPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
        }
    }
}

