/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightTags;
import com.mushroom.midnight.common.world.feature.config.MidnightOreConfig;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class MidnightOreFeature
extends Feature<MidnightOreConfig> {
    public MidnightOreFeature(Function<Dynamic<?>, ? extends MidnightOreConfig> deserialize) {
        super(deserialize);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, MidnightOreConfig config) {
        float f = random.nextFloat() * (float)Math.PI;
        float length = (float)config.size / 8.0f;
        int halfSize = MathHelper.func_76123_f((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double startX = (float)pos.func_177958_n() + MathHelper.func_76126_a((float)f) * length;
        double endX = (float)pos.func_177958_n() - MathHelper.func_76126_a((float)f) * length;
        double startZ = (float)pos.func_177952_p() + MathHelper.func_76134_b((float)f) * length;
        double endZ = (float)pos.func_177952_p() - MathHelper.func_76134_b((float)f) * length;
        double startY = pos.func_177956_o() + random.nextInt(3) - 2;
        double endY = pos.func_177956_o() + random.nextInt(3) - 2;
        int minX = pos.func_177958_n() - MathHelper.func_76123_f((float)length) - halfSize;
        int minY = pos.func_177956_o() - 2 - halfSize;
        int minZ = pos.func_177952_p() - MathHelper.func_76123_f((float)length) - halfSize;
        int sizeXZ = 2 * (MathHelper.func_76123_f((float)length) + halfSize);
        int sizeY = 2 * (2 + halfSize);
        for (int x = minX; x <= minX + sizeXZ; ++x) {
            for (int z = minZ; z <= minZ + sizeXZ; ++z) {
                if (minY > world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z)) continue;
                return this.tryPlaceVein(world, random, config, startX, endX, startZ, endZ, startY, endY, minX, minY, minZ, sizeXZ, sizeY);
            }
        }
        return false;
    }

    private boolean tryPlaceVein(IWorld world, Random random, MidnightOreConfig config, double startX, double endX, double startZ, double endZ, double startY, double endY, int minX, int minY, int minZ, int sizeXZ, int sizeY) {
        int i;
        int placedBlocks = 0;
        BitSet mask = new BitSet(sizeXZ * sizeY * sizeXZ);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        double[] xTable = new double[config.size];
        double[] yTable = new double[config.size];
        double[] zTable = new double[config.size];
        double[] distTable = new double[config.size];
        for (i = 0; i < config.size; ++i) {
            float alpha = (float)i / (float)config.size;
            double x = MathHelper.func_219803_d((double)alpha, (double)startX, (double)endX);
            double y = MathHelper.func_219803_d((double)alpha, (double)startY, (double)endY);
            double z = MathHelper.func_219803_d((double)alpha, (double)startZ, (double)endZ);
            double s = random.nextDouble() * (double)config.size / 16.0;
            double dist = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * alpha)) + 1.0f) * s + 1.0) / 2.0;
            xTable[i] = x;
            yTable[i] = y;
            zTable[i] = z;
            distTable[i] = dist;
        }
        for (i = 0; i < config.size - 1; ++i) {
            if (distTable[i] <= 0.0) continue;
            for (int j = i + 1; j < config.size; ++j) {
                double deltaRad;
                double deltaZ;
                double deltaY;
                double deltaX;
                if (distTable[j] <= 0.0 || !((deltaX = xTable[i] - xTable[j]) * deltaX + (deltaY = yTable[i] - yTable[j]) * deltaY + (deltaZ = zTable[i] - zTable[j]) * deltaZ < (deltaRad = distTable[i] - distTable[j]) * deltaRad)) continue;
                if (deltaRad > 0.0) {
                    distTable[j] = -1.0;
                    continue;
                }
                distTable[i] = -1.0;
            }
        }
        for (i = 0; i < config.size; ++i) {
            double distance = distTable[i];
            if (distance < 0.0) continue;
            double x = xTable[i];
            double y = yTable[i];
            double z = zTable[i];
            int minBX = Math.max(MathHelper.func_76128_c((double)(x - distance)), minX);
            int minBY = Math.max(MathHelper.func_76128_c((double)(y - distance)), minY);
            int minBZ = Math.max(MathHelper.func_76128_c((double)(z - distance)), minZ);
            int maxBX = Math.max(MathHelper.func_76128_c((double)(x + distance)), minBX);
            int maxBY = Math.max(MathHelper.func_76128_c((double)(y + distance)), minBY);
            int maxBZ = Math.max(MathHelper.func_76128_c((double)(z + distance)), minBZ);
            for (int bx = minBX; bx <= maxBX; ++bx) {
                double deltaX = ((double)bx + 0.5 - x) / distance;
                if (!(deltaX * deltaX < 1.0)) continue;
                for (int by = minBY; by <= maxBY; ++by) {
                    double deltaY = ((double)by + 0.5 - y) / distance;
                    if (!(deltaX * deltaX + deltaY * deltaY < 1.0)) continue;
                    for (int bz = minBZ; bz <= maxBZ; ++bz) {
                        int maskIndex;
                        double deltaZ = ((double)bz + 0.5 - z) / distance;
                        if (!(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < 1.0) || mask.get(maskIndex = bx - minX + (by - minY) * sizeXZ + (bz - minZ) * sizeXZ * sizeY)) continue;
                        mask.set(maskIndex);
                        pos.func_181079_c(bx, by, bz);
                        if (!world.func_180495_p((BlockPos)pos).func_203425_a(MidnightTags.Blocks.CAN_HOLD_ORES)) continue;
                        world.func_180501_a((BlockPos)pos, config.state, 2);
                        ++placedBlocks;
                    }
                }
            }
        }
        return placedBlocks > 0;
    }
}

