/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.world.feature.config.CrystalClusterConfig;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class CrystalClusterFeature
extends Feature<CrystalClusterConfig> {
    private final int radius;
    private final int maxHeight;

    public CrystalClusterFeature(Function<Dynamic<?>, ? extends CrystalClusterConfig> deserialize, int radius, int maxHeight) {
        super(deserialize);
        this.radius = radius;
        this.maxHeight = maxHeight;
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos origin, CrystalClusterConfig config) {
        int size = this.radius * 2 + 1;
        int[] heights = new int[size * size];
        BlockPos basePos = this.populateHeights(world, rand, origin, heights, size);
        if (basePos == null || !this.canGenerate(world, origin, heights, size)) {
            return false;
        }
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int localZ = -this.radius; localZ <= this.radius; ++localZ) {
            for (int localX = -this.radius; localX <= this.radius; ++localX) {
                int height = heights[localX + this.radius + (localZ + this.radius) * size];
                if (height <= 0) continue;
                mutablePos.func_181079_c(basePos.func_177958_n() + localX, basePos.func_177956_o(), basePos.func_177952_p() + localZ);
                this.generatePillar(world, rand, mutablePos, height, config);
            }
        }
        return true;
    }

    private BlockPos populateHeights(IWorld world, Random rand, BlockPos origin, int[] heights, int size) {
        BlockPos.Mutable basePos = new BlockPos.Mutable(origin);
        for (int localZ = -this.radius; localZ <= this.radius; ++localZ) {
            for (int localX = -this.radius; localX <= this.radius; ++localX) {
                double deltaZ;
                int index = localX + this.radius + (localZ + this.radius) * size;
                double deltaX = (double)localX + rand.nextDouble() * 2.0 - 1.0;
                double distance = Math.sqrt(deltaX * deltaX + (deltaZ = (double)localZ + rand.nextDouble() * 2.0 - 1.0) * deltaZ);
                double alpha = ((double)this.radius - distance) / (double)this.radius;
                int height = MathHelper.func_76128_c((double)(alpha * (double)this.maxHeight));
                if (height <= 0) continue;
                BlockPos surfacePos = this.findSurfaceBelow(world, origin.func_177982_a(localX, 0, localZ), 16);
                if (surfacePos == null) {
                    return null;
                }
                if (surfacePos.func_177956_o() < basePos.func_177956_o()) {
                    basePos.func_185336_p(surfacePos.func_177956_o());
                }
                heights[index] = height;
            }
        }
        return basePos.func_185334_h();
    }

    private boolean canGenerate(IWorld world, BlockPos origin, int[] heights, int size) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(origin);
        int centerHeight = heights[this.radius + this.radius * size] + 1;
        for (int localY = 0; localY < centerHeight; ++localY) {
            mutablePos.func_185336_p(origin.func_177956_o() + localY);
            if (world.func_175623_d((BlockPos)mutablePos)) continue;
            return false;
        }
        return true;
    }

    private void generatePillar(IWorld world, Random rand, BlockPos.Mutable mutablePos, int height, CrystalClusterConfig config) {
        int originY = mutablePos.func_177956_o();
        for (int offsetY = 0; offsetY < height; ++offsetY) {
            mutablePos.func_185336_p(originY + offsetY);
            this.trySetBlock(world, (BlockPos)mutablePos, config.rock);
        }
        if (rand.nextInt(2) == 0) {
            mutablePos.func_185336_p(originY + height);
            this.trySetBlock(world, (BlockPos)mutablePos, config.crystal);
        }
    }

    private BlockPos findSurfaceBelow(IWorld world, BlockPos origin, int maxSteps) {
        BlockState currentState = world.func_180495_p(origin);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(origin);
        for (int i = 0; i < maxSteps; ++i) {
            currentPos.func_189536_c(Direction.DOWN);
            BlockState nextState = world.func_180495_p((BlockPos)currentPos);
            if (currentState.func_177230_c() == Blocks.field_150350_a && nextState.func_200132_m()) {
                currentPos.func_189536_c(Direction.UP);
                return currentPos.func_185334_h();
            }
            currentState = nextState;
        }
        return null;
    }

    private void trySetBlock(IWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
    }
}

