/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import com.google.common.collect.Queues;
import java.util.Deque;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MatrixStack {
    private final Deque<Entry> stack = (Deque)Util.func_200696_a((Object)Queues.newArrayDeque(), p_227864_0_ -> {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_226591_a_();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.func_226119_c_();
        p_227864_0_.add(new Entry(matrix4f, matrix3f));
    });

    public MatrixStack(int initPoolSize) {
        for (int i = 0; i < initPoolSize; ++i) {
            Matrix4f matrix = new Matrix4f();
            Matrix3f matrix2 = new Matrix3f();
            this.stack.push(new Entry(matrix, matrix2));
        }
    }

    public void translate(double p_227861_1_, double p_227861_3_, double p_227861_5_) {
        Entry matrixstack$entry = this.stack.getLast();
        matrixstack$entry.positionMatrix.func_226595_a_(Matrix4f.func_226599_b_((float)((float)p_227861_1_), (float)((float)p_227861_3_), (float)((float)p_227861_5_)));
    }

    public void scale(float p_227862_1_, float p_227862_2_, float p_227862_3_) {
        Entry matrixstack$entry = this.stack.getLast();
        matrixstack$entry.positionMatrix.func_226595_a_(Matrix4f.func_226593_a_((float)p_227862_1_, (float)p_227862_2_, (float)p_227862_3_));
        if (p_227862_1_ == p_227862_2_ && p_227862_2_ == p_227862_3_) {
            if (p_227862_1_ > 0.0f) {
                return;
            }
            matrixstack$entry.normalMatrix.func_226111_a_(-1.0f);
        }
        float f = 1.0f / p_227862_1_;
        float f1 = 1.0f / p_227862_2_;
        float f2 = 1.0f / p_227862_3_;
        float f3 = MathHelper.func_226166_j_((float)(f * f1 * f2));
        matrixstack$entry.normalMatrix.func_226118_b_(Matrix3f.func_226117_b_((float)(f3 * f), (float)(f3 * f1), (float)(f3 * f2)));
    }

    public void rotate(Quaternion p_227863_1_) {
        Entry matrixstack$entry = this.stack.getLast();
        matrixstack$entry.positionMatrix.func_226596_a_(p_227863_1_);
        matrixstack$entry.normalMatrix.func_226115_a_(p_227863_1_);
    }

    public void push() {
        Entry matrixstack$entry = this.stack.getLast();
        this.stack.addLast(new Entry(matrixstack$entry.positionMatrix.func_226601_d_(), matrixstack$entry.normalMatrix.func_226121_d_()));
    }

    public void pop() {
        this.stack.removeLast();
    }

    public Entry getLast() {
        return this.stack.getLast();
    }

    public boolean clear() {
        return this.stack.size() == 1;
    }

    public void transform(Quaternion point) {
        Matrix4f matrix = this.stack.getLast().positionMatrix;
        matrix.func_226596_a_(point);
    }

    public void transform(Vector3f vector) {
        Matrix4f matrix = this.stack.getLast().positionMatrix;
        matrix.func_226596_a_(new Quaternion(vector.func_195899_a(), vector.func_195900_b(), vector.func_195902_c(), 1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Entry {
        private final Matrix4f positionMatrix;
        private final Matrix3f normalMatrix;

        private Entry(Matrix4f p_i225909_1_, Matrix3f p_i225909_2_) {
            this.positionMatrix = p_i225909_1_;
            this.normalMatrix = p_i225909_2_;
        }

        public Matrix4f getPositionMatrix() {
            return this.positionMatrix;
        }

        public Matrix3f getNormalMatrix() {
            return this.normalMatrix;
        }
    }
}

