/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;

public class DirectionalShape {
    private final double minX;
    private final double minY;
    private final double minZ;
    private final double maxX;
    private final double maxY;
    private final double maxZ;
    private final VoxelShape[] cache = new VoxelShape[Direction.values().length];

    public DirectionalShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public VoxelShape get(Direction facing) {
        VoxelShape cached = this.cache[facing.func_176745_a()];
        if (cached == null) {
            VoxelShape computed;
            this.cache[facing.func_176745_a()] = computed = this.compute(facing);
            return computed;
        }
        return cached;
    }

    private VoxelShape compute(Direction facing) {
        switch (facing) {
            default: {
                return Block.func_208617_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
            }
            case WEST: {
                return Block.func_208617_a((double)this.minZ, (double)this.minY, (double)(16.0 - this.maxX), (double)this.maxZ, (double)this.maxY, (double)(16.0 - this.minX));
            }
            case SOUTH: {
                return Block.func_208617_a((double)(16.0 - this.maxX), (double)this.minY, (double)(16.0 - this.maxZ), (double)(16.0 - this.minX), (double)this.maxY, (double)(16.0 - this.minZ));
            }
            case EAST: {
                return Block.func_208617_a((double)(16.0 - this.maxZ), (double)this.minY, (double)this.minX, (double)(16.0 - this.minZ), (double)this.maxY, (double)this.maxX);
            }
            case DOWN: {
                return Block.func_208617_a((double)(16.0 - this.maxX), (double)this.minZ, (double)(16.0 - this.maxY), (double)(16.0 - this.minX), (double)this.maxZ, (double)(16.0 - this.minY));
            }
            case UP: 
        }
        return Block.func_208617_a((double)this.minX, (double)(16.0 - this.maxZ), (double)this.minY, (double)this.maxX, (double)(16.0 - this.minZ), (double)this.maxY);
    }
}

