/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.tile;

import com.mushroom.midnight.common.inventory.CacheContainer;
import com.mushroom.midnight.common.registry.MidnightTileEntities;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CacheTileEntity
extends LockableLootTileEntity
implements INamedContainerProvider {
    private int inventSize = 4;
    private final NonNullList<ItemStack> cacheContents = NonNullList.func_191197_a((int)this.inventSize, (Object)ItemStack.field_190927_a);

    protected CacheTileEntity(TileEntityType<?> entityType) {
        super(entityType);
    }

    public CacheTileEntity() {
        this(MidnightTileEntities.CACHE);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.midnight.viridshroom_stem_cache", new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventSize;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.cacheContents;
    }

    protected void func_199721_a(NonNullList<ItemStack> items) {
        this.cacheContents.clear();
        this.cacheContents.addAll(items);
    }

    public boolean func_191420_l() {
        return this.cacheContents.stream().allMatch(ItemStack::func_190926_b);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.cacheContents.clear();
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.cacheContents);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.cacheContents);
        }
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new InvWrapper((IInventory)this)).cast();
        }
        return super.getCapability(cap, side);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return this.createMenu(id, playerInventory, playerInventory.field_70458_d);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        if (this.func_213904_e(player)) {
            this.func_184281_d(playerInventory.field_70458_d);
            return new CacheContainer(id, playerInventory, (IInventory)this);
        }
        return null;
    }
}

