/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.common.registry.MidnightItems;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class MidnightArmorMaterials {
    private static final int[] DURABILITY = new int[]{13, 15, 16, 11};
    public static final IArmorMaterial ROCKSHROOM = new Builder().withName("midnight:rockshroom").withDurabilityFactor(15).withDamageReductionAmounts(new int[]{2, 3, 4, 1}).withEnchantability(5).withToughness(1.0f).withRepairMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.ROCKSHROOM_CLUMP})).build();
    public static final IArmorMaterial TENEBRUM = new Builder().withName("midnight:tenebrum").withDurabilityFactor(30).withDamageReductionAmounts(new int[]{3, 6, 8, 3}).withEnchantability(9).withToughness(2.0f).withRepairMaterial(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.TENEBRUM_INGOT})).build();

    private static class Builder {
        private String name;
        private int durabilityFactor;
        private int[] damageReductionAmounts;
        private int enchantability;
        private SoundEvent sound = SoundEvents.field_187719_p;
        private Ingredient repairMaterial;
        private float toughness;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDurabilityFactor(int durabilityFactor) {
            this.durabilityFactor = durabilityFactor;
            return this;
        }

        public Builder withDamageReductionAmounts(int[] damageReductionAmount) {
            this.damageReductionAmounts = damageReductionAmount;
            return this;
        }

        public Builder withEnchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder withSound(SoundEvent sound) {
            this.sound = sound;
            return this;
        }

        public Builder withRepairMaterial(Ingredient repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public Builder withToughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public IArmorMaterial build() {
            return new IArmorMaterial(){

                public int func_200896_a(EquipmentSlotType slot) {
                    return DURABILITY[slot.func_188454_b()] * durabilityFactor;
                }

                public int func_200902_b(EquipmentSlotType slot) {
                    return damageReductionAmounts[slot.func_188454_b()];
                }

                public int func_200900_a() {
                    return enchantability;
                }

                public SoundEvent func_200899_b() {
                    return sound;
                }

                public Ingredient func_200898_c() {
                    return repairMaterial;
                }

                public String func_200897_d() {
                    return name;
                }

                public float func_200901_e() {
                    return toughness;
                }
            };
        }
    }
}

