/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.network;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.AnimationCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationMessage {
    private int entityId;
    private AnimationCapability.Type animationType;
    private int duration;

    private AnimationMessage(int entityId, AnimationCapability.Type animationType, int duration) {
        this.entityId = entityId;
        this.animationType = animationType;
        this.duration = duration;
    }

    public AnimationMessage(Entity entity, AnimationCapability.Type animationType, int duration) {
        this(entity.func_145782_y(), animationType, duration);
    }

    public void serialize(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.animationType.ordinal());
        buffer.writeInt(this.duration);
    }

    public static AnimationMessage deserialize(PacketBuffer buffer) {
        int entityId = buffer.readInt();
        AnimationCapability.Type animationType = AnimationCapability.Type.values()[buffer.readInt() % AnimationCapability.Type.values().length];
        int duration = buffer.readInt();
        return new AnimationMessage(entityId, animationType, duration);
    }

    public static boolean handle(AnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(message.entityId);
                if (entity != null) {
                    entity.getCapability(Midnight.ANIMATION_CAP, null).ifPresent(animationCap -> animationCap.setAnimation(entity, message.animationType, message.duration));
                }
            });
        }
        return true;
    }
}

