/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class InBlockLootCondition
implements ILootCondition {
    private final Block block;

    public InBlockLootCondition(Block block) {
        this.block = block;
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        return entity != null && context.func_202879_g().func_180495_p(entity.func_180425_c()).func_177230_c() == this.block;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<InBlockLootCondition> {
        public Serializer() {
            super(new ResourceLocation("midnight", "in_block"), InBlockLootCondition.class);
        }

        public void serialize(JsonObject json, InBlockLootCondition value, JsonSerializationContext context) {
            json.addProperty("block", value.block.getRegistryName().toString());
        }

        public InBlockLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("block")) {
                throw new JsonSyntaxException("Missing block tag, expected to find a block registry name");
            }
            ResourceLocation rl = new ResourceLocation(json.get("block").getAsString());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
            if (block == null) {
                throw new JsonSyntaxException("Invalid block tag. " + rl + " does not exist in the block registry.");
            }
            return new InBlockLootCondition(block);
        }
    }
}

