/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="midnight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FishingLoot {
    private static ResourceLocation MIDNIGHT_FISHING = new ResourceLocation("midnight", "fishing");
    private static final Field fieldIsFrozen = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");
    private static final Field fieldPools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
    private static final Field fieldConditions = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186454_b");
    private static final Field fieldCombinedConditions = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_216101_c");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186387_al)) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            server.func_213165_a(() -> {
                LootTable midnightFishing = event.getLootTableManager().func_186521_a(MIDNIGHT_FISHING);
                if (midnightFishing == LootTable.field_186464_a) {
                    Midnight.LOGGER.warn("The loottable for midnight fishing is absent");
                } else {
                    try {
                        fieldIsFrozen.setBoolean(midnightFishing, false);
                        fieldIsFrozen.setBoolean(event.getTable(), false);
                        FishingLoot.addConditionToAllMainPools(event.getTable(), context -> !MidnightUtil.isMidnightDimension((World)context.func_202879_g()));
                        LootPool midnightPool = midnightFishing.getPool("midnight_fishing");
                        FishingLoot.addConditionToPool(context -> MidnightUtil.isMidnightDimension((World)context.func_202879_g()), midnightPool);
                        event.getTable().addPool(midnightPool);
                        fieldIsFrozen.setBoolean(event.getTable(), true);
                        fieldIsFrozen.setBoolean(midnightFishing, true);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private static void addConditionToAllMainPools(LootTable table, ILootCondition condition) throws IllegalAccessException {
        List pools = null;
        pools = (List)fieldPools.get(table);
        if (pools != null) {
            for (LootPool pool : pools) {
                FishingLoot.addConditionToPool(condition, pool);
            }
        }
    }

    private static void addConditionToPool(ILootCondition condition, LootPool pool) throws IllegalAccessException {
        List conditions = (List)fieldConditions.get(pool);
        conditions.add(condition);
        fieldCombinedConditions.set(pool, LootConditionManager.func_216305_a((Predicate[])((Predicate[])conditions.toArray(new ILootCondition[0]))));
    }
}

