/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.item.tool;

import com.mushroom.midnight.common.registry.MidnightFluids;
import com.mushroom.midnight.common.registry.MidnightItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class MidnightFluidBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @Nonnull
    protected ItemStack container;

    public MidnightFluidBucketWrapper(@Nonnull ItemStack container) {
        this.container = container;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid.getFluid() == Fluids.field_204546_a || fluid.getFluid() == Fluids.field_204547_b || fluid.getFluid().getRegistryName().equals((Object)new ResourceLocation("milk"))) {
            return true;
        }
        return fluid.getFluid().getAttributes().getBucket(fluid) != null;
    }

    @Nonnull
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (item instanceof BucketItem) {
            return new FluidStack(((BucketItem)item).getFluid(), 1000);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(@Nonnull FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack((IItemProvider)MidnightItems.ROCKSHROOM_BUCKET) : MidnightFluidBucketWrapper.getFilledBucket(fluidStack);
    }

    @Nonnull
    public static ItemStack getFilledBucket(@Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (!fluidStack.hasTag() || fluidStack.getTag().isEmpty()) {
            if (fluid == Fluids.field_204546_a) {
                return new ItemStack((IItemProvider)MidnightItems.WATER_ROCKSHROOM_BUCKET);
            }
            if (fluid == MidnightFluids.DARK_WATER) {
                return new ItemStack((IItemProvider)MidnightItems.DARK_WATER_BUCKET);
            }
        }
        return fluid.getAttributes().getBucket(fluidStack);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || resource.getAmount() < 1000 || this.container.func_77973_b() instanceof MilkBucketItem || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return 1000;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || resource.getAmount() < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.func_190916_E() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }
}

