/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.fluid;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightFluids;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightTags;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class DarkWaterFluid
extends WaterFluid {
    private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("midnight", "blocks/dark_water_still");
    private static final ResourceLocation FLOW_TEXTURE = new ResourceLocation("midnight", "blocks/dark_water_flow");

    public Fluid func_210197_e() {
        return MidnightFluids.FLOWING_DARK_WATER;
    }

    public Fluid func_210198_f() {
        return MidnightFluids.DARK_WATER;
    }

    public Item func_204524_b() {
        return MidnightItems.DARK_WATER_BUCKET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World world, BlockPos pos, IFluidState state, Random random) {
        if (state.func_206889_d() || ((Boolean)state.func_177229_b((IProperty)field_207209_a)).booleanValue()) {
            return;
        }
        if (random.nextInt(64) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
        }
    }

    public BlockState func_204527_a(IFluidState state) {
        return (BlockState)MidnightBlocks.DARK_WATER.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(DarkWaterFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid.func_207185_a(MidnightTags.Fluids.DARK_WATER);
    }

    protected void func_205574_a(IWorld world, BlockPos intoPos, BlockState intoBlock, Direction direction, IFluidState state) {
        IFluidState intoFluid;
        if (direction == Direction.DOWN && ((intoFluid = world.func_204610_c(intoPos)).func_206884_a(FluidTags.field_206960_b) || intoFluid.func_206884_a(MidnightTags.Fluids.MIASMA))) {
            this.mixInto(world, intoPos, MidnightBlocks.TRENCHSTONE.func_176223_P());
            return;
        }
        super.func_205574_a(world, intoPos, intoBlock, direction, state);
    }

    private void mixInto(IWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
        world.func_217379_c(1501, pos, 0);
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)STILL_TEXTURE, (ResourceLocation)FLOW_TEXTURE).build((Fluid)this);
    }

    public static class Source
    extends DarkWaterFluid {
        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends DarkWaterFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> container) {
            super.func_207184_a(container);
            container.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

