/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;

public class SearchForBlockGoal
extends Goal {
    private final CreatureEntity owner;
    protected final Predicate<BlockState> blockPredicate;
    private final double speed;
    @Nullable
    private BlockPos destinationBlock = null;
    private final int searchDist;
    private final int searchDelay;
    private int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;

    public SearchForBlockGoal(CreatureEntity owner, Predicate<BlockState> blockPredicate, double speed, int searchDist, int searchDelay) {
        this.owner = owner;
        this.blockPredicate = blockPredicate;
        this.searchDist = searchDist;
        this.searchDelay = searchDelay / 2 + (int)((float)searchDelay * owner.func_70681_au().nextFloat());
        this.speed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.owner.func_70638_az() != null) {
            return false;
        }
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.searchDelay + this.owner.func_70681_au().nextInt(this.searchDelay);
        return this.searchForDestination();
    }

    private boolean searchForDestination() {
        BlockPos currentPos = this.owner.func_180425_c();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)currentPos.func_177982_a(-this.searchDist, -1, -this.searchDist), (BlockPos)currentPos.func_177982_a(this.searchDist, 1, this.searchDist))) {
            if (!this.owner.field_70170_p.func_175667_e(pos) || !this.blockPredicate.test(this.owner.field_70170_p.func_180495_p(pos))) continue;
            this.destinationBlock = pos;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.destinationBlock != null && this.owner.func_70638_az() == null && this.owner.func_70781_l() && this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo(this.destinationBlock);
    }

    private boolean shouldMoveTo(BlockPos pos) {
        return this.blockPredicate.test(this.owner.field_70170_p.func_180495_p(pos));
    }

    public void func_75249_e() {
        assert (this.destinationBlock != null);
        this.owner.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.speed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.owner.func_70681_au().nextInt(this.owner.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        boolean isNearDestination;
        assert (this.destinationBlock != null);
        boolean bl = isNearDestination = this.owner.func_70092_e((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5) <= 1.0;
        this.timeoutCounter = isNearDestination ? --this.timeoutCounter : ++this.timeoutCounter;
        if (isNearDestination) {
            this.owner.func_213390_a(this.destinationBlock, 20);
            this.destinationBlock = null;
        }
    }
}

