/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.entity.creature.RifterEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;

public abstract class RifterFollowGoal
extends Goal {
    protected final RifterEntity owner;
    protected final double followSpeed;
    protected BlockPos lastSeenPos;
    protected Path path;
    protected int invalidCounter;
    protected boolean navigatingFromMemory;

    public RifterFollowGoal(RifterEntity owner, double followSpeed) {
        this.owner = owner;
        this.followSpeed = followSpeed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    protected abstract void handleInteract(LivingEntity var1);

    public boolean func_75250_a() {
        LivingEntity target = this.owner.func_70638_az();
        if (this.shouldFollow(target)) {
            this.path = this.owner.func_70661_as().func_75494_a((Entity)target, 0);
            return this.path != null;
        }
        return false;
    }

    public void func_75249_e() {
        this.owner.func_70661_as().func_75484_a(this.path, this.followSpeed);
    }

    public void func_75246_d() {
        Path targetPath;
        LivingEntity target = this.owner.func_70638_az();
        if (target == null) {
            return;
        }
        if (!this.navigatingFromMemory) {
            this.owner.func_70671_ap().func_75651_a((Entity)target, 20.0f, 20.0f);
        }
        if ((targetPath = this.computeFollowPath(target)) == null) {
            this.owner.func_70624_b(null);
            return;
        }
        Path currentPath = this.owner.func_70661_as().func_75505_d();
        if (currentPath != targetPath) {
            this.owner.func_70661_as().func_75484_a(targetPath, this.followSpeed);
        }
        if (this.canInteract(target)) {
            this.handleInteract(target);
        }
    }

    @Nullable
    protected Path computeFollowPath(LivingEntity target) {
        double followRange;
        double distanceSq;
        if (this.path.func_75879_b()) {
            this.path = null;
        }
        if ((distanceSq = this.owner.func_70068_e((Entity)target)) < (followRange = this.owner.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) * followRange) {
            this.updateFollowVisible(target);
        } else if (!this.navigatingFromMemory && this.lastSeenPos != null) {
            this.owner.func_70661_as().func_75499_g();
            this.path = this.owner.func_70661_as().func_179680_a(this.lastSeenPos, 0);
            this.navigatingFromMemory = true;
        }
        return this.path;
    }

    protected void updateFollowVisible(LivingEntity target) {
        if (this.shouldInvalidatePath(target) || this.navigatingFromMemory) {
            this.invalidCounter = 0;
            this.owner.func_70661_as().func_75499_g();
            this.path = this.owner.func_70661_as().func_75494_a((Entity)target, 0);
            if (this.path != null) {
                this.lastSeenPos = target.func_180425_c();
                this.navigatingFromMemory = false;
            } else {
                this.navigatingFromMemory = true;
            }
        }
    }

    protected boolean shouldInvalidatePath(LivingEntity target) {
        int invalidateTime = this.getPathInvalidateTime(target);
        return ++this.invalidCounter > invalidateTime;
    }

    protected int getPathInvalidateTime(LivingEntity target) {
        double distanceSq = this.owner.func_70068_e((Entity)target);
        if (distanceSq < 16.0) {
            return 5;
        }
        if (distanceSq < 64.0) {
            return 10;
        }
        return 20;
    }

    protected boolean canInteract(LivingEntity target) {
        double interactReach;
        double distanceSq = this.owner.func_70068_e((Entity)target);
        return distanceSq < (interactReach = this.getInteractReach(target)) * interactReach;
    }

    protected double getInteractReach(LivingEntity target) {
        double averageWidth = (double)(this.owner.func_213311_cf() + target.func_213311_cf()) / 2.0;
        return averageWidth + 0.5;
    }

    public boolean func_75253_b() {
        return this.path != null && this.shouldFollow(this.owner.func_70638_az());
    }

    public void func_75251_c() {
        this.owner.func_70661_as().func_75499_g();
        this.path = null;
        this.lastSeenPos = null;
        this.navigatingFromMemory = false;
        if (!this.shouldFollow(this.owner.func_70638_az())) {
            this.owner.func_70624_b(null);
        }
    }

    protected boolean shouldFollow(LivingEntity target) {
        PlayerEntity player;
        if (target == null) {
            return false;
        }
        if (target instanceof PlayerEntity && ((player = (PlayerEntity)target).func_175149_v() || player.func_184812_l_())) {
            return false;
        }
        return target.func_70089_S();
    }
}

