/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class FishJumpGoal
extends JumpGoal {
    private static final int[] ranges = new int[]{0, 1, 4, 5, 6, 7};
    private final AbstractFishEntity fishEntity;
    private final int chance;
    private boolean isWater;

    public FishJumpGoal(AbstractFishEntity fish, int chance) {
        this.fishEntity = fish;
        this.chance = chance;
    }

    public boolean func_75250_a() {
        if (this.fishEntity.func_70681_au().nextInt(this.chance) != 0) {
            return false;
        }
        Direction direction = this.fishEntity.func_184172_bi();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockpos = new BlockPos((Entity)this.fishEntity);
        for (int k : ranges) {
            if (this.isInWater(blockpos, i, j, k) && this.findSpace(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean isInWater(BlockPos pos, int x, int z, int range) {
        BlockPos blockpos = pos.func_177982_a(x * range, 0, z * range);
        return this.fishEntity.field_70170_p.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a) && !this.fishEntity.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean findSpace(BlockPos pos, int x, int z, int range) {
        return this.fishEntity.field_70170_p.func_180495_p(pos.func_177982_a(x * range, 1, z * range)).func_196958_f() && this.fishEntity.field_70170_p.func_180495_p(pos.func_177982_a(x * range, 2, z * range)).func_196958_f();
    }

    public boolean func_75253_b() {
        double d0 = this.fishEntity.func_213322_ci().field_72448_b;
        return !(d0 * d0 < (double)0.03f && this.fishEntity.field_70125_A != 0.0f && Math.abs(this.fishEntity.field_70125_A) < 10.0f && this.fishEntity.func_70090_H() || this.fishEntity.field_70122_E);
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        LivingEntity entity = this.fishEntity.func_70638_az();
        Direction direction = this.fishEntity.func_184172_bi();
        if (entity != null && this.fishEntity.func_70068_e((Entity)entity) < 12.0) {
            this.fishEntity.func_70671_ap().func_75651_a((Entity)entity, 60.0f, 30.0f);
            Vec3d vec3d = new Vec3d(entity.func_226277_ct_() - this.fishEntity.func_226277_ct_(), entity.func_226278_cu_() - this.fishEntity.func_226278_cu_(), entity.func_226281_cx_() - this.fishEntity.func_226281_cx_()).func_72432_b();
            this.fishEntity.func_213317_d(this.fishEntity.func_213322_ci().func_72441_c(vec3d.field_72450_a * 0.45, 0.56, vec3d.field_72449_c * 0.45));
        } else {
            this.fishEntity.func_213317_d(this.fishEntity.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, 0.7, (double)direction.func_82599_e() * 0.6));
        }
        this.fishEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.fishEntity.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        boolean flag = this.isWater;
        if (!flag) {
            IFluidState ifluidstate = this.fishEntity.field_70170_p.func_204610_c(new BlockPos((Entity)this.fishEntity));
            this.isWater = ifluidstate.func_206884_a(FluidTags.field_206959_a);
        }
        if (this.isWater && !flag) {
            this.fishEntity.func_184185_a(SoundEvents.field_187547_bF, 1.0f, 1.0f);
        }
        Vec3d vec3d = this.fishEntity.func_213322_ci();
        if (!(vec3d.field_72448_b * vec3d.field_72448_b < (double)0.03f) || this.fishEntity.field_70125_A == 0.0f) {
            double d0 = Math.sqrt(Entity.func_213296_b((Vec3d)vec3d));
            double d1 = Math.signum(-vec3d.field_72448_b) * Math.acos(d0 / vec3d.func_72433_c()) * 57.2957763671875;
            this.fishEntity.field_70125_A = (float)d1;
        }
        LivingEntity entity = this.fishEntity.func_70638_az();
        if (entity != null && this.fishEntity.func_70068_e((Entity)entity) <= this.getAttackReachSqr(entity)) {
            this.fishEntity.func_70652_k((Entity)entity);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.fishEntity.func_213311_cf() * 1.5f * this.fishEntity.func_213311_cf() * 1.5f + attackTarget.func_213311_cf();
    }
}

