/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.common.registry.MidnightCriterion;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightLootTables;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.util.MidnightUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class ThrownGeodeEntity
extends ThrowableEntity
implements IRendersAsItem {
    private static final byte POPPED_STATE_ID = 3;

    public ThrownGeodeEntity(World world) {
        super(MidnightEntities.THROWN_GEODE, world);
    }

    public ThrownGeodeEntity(EntityType<? extends ThrownGeodeEntity> entityType, World world) {
        super(entityType, world);
    }

    public ThrownGeodeEntity(World world, double x, double y, double z) {
        super(MidnightEntities.THROWN_GEODE, x, y, z, world);
    }

    public ThrownGeodeEntity(World world, LivingEntity thrower) {
        super(MidnightEntities.THROWN_GEODE, thrower, world);
    }

    public ThrownGeodeEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(MidnightEntities.THROWN_GEODE, world);
    }

    protected void func_70088_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            this.spawnPopParticles();
        }
    }

    private void spawnPopParticles() {
        int i;
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), MidnightSounds.EGG_CRACKED, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
        for (i = 0; i < 8; ++i) {
            double velX = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            double velY = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)MidnightItems.GEODE)), this.func_226277_ct_(), this.func_226278_cu_() + 0.1, this.func_226281_cx_(), velX, 0.1, velY);
        }
        for (i = 0; i < 2; ++i) {
            double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            double offsetY = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            this.field_70170_p.func_195594_a((IParticleData)MidnightParticleTypes.FURNACE_FLAME, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.canBreakOn(result)) {
                ServerPlayerEntity player;
                ServerPlayerEntity serverPlayerEntity = player = this.field_70192_c instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.field_70192_c : null;
                if (player != null) {
                    MidnightCriterion.THROWN_GEODE.trigger(player);
                }
                this.dropLootWhenBroken(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            } else {
                MidnightUtil.spawnItemStack(this.field_70170_p, this.func_180425_c(), MidnightItems.GEODE);
            }
            this.func_70106_y();
        }
    }

    private boolean canBreakOn(RayTraceResult result) {
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockState impactedState = this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a());
        return impactedState.func_185904_a() == Material.field_151576_e || impactedState.func_185904_a() == Material.field_151573_f;
    }

    private void dropLootWhenBroken(@Nullable ServerPlayerEntity player) {
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76377_j).func_216015_a(LootParameters.field_216286_f, (Object)this.func_180425_c());
        if (player != null) {
            builder = builder.func_216015_a(LootParameters.field_216284_d, (Object)player).func_186469_a(player.func_184817_da());
        }
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(MidnightLootTables.LOOT_TABLE_THROWN_GEODE);
        for (ItemStack itemstack : loottable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216263_d))) {
            this.func_70099_a(itemstack, 0.1f);
        }
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)MidnightItems.GEODE);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

