/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="midnight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BladeshroomCapEntity
extends AbstractArrowEntity {
    private static final ThreadLocal<Boolean> HIT_ACTIVE = ThreadLocal.withInitial(() -> false);
    private static final float DAMAGE = 1.0f;
    private static final double GRAVITY = 0.015;
    public float spin;
    public float prevSpin;

    public BladeshroomCapEntity(EntityType<BladeshroomCapEntity> entityType, World world) {
        super(entityType, world);
        this.func_70239_b(1.0);
    }

    public BladeshroomCapEntity(World world, LivingEntity thrower) {
        super(MidnightEntities.BLADESHROOM_CAP, thrower, world);
        this.func_70239_b(1.0);
    }

    public BladeshroomCapEntity(World world, double x, double y, double z) {
        super(MidnightEntities.BLADESHROOM_CAP, x, y, z, world);
        this.func_70239_b(1.0);
    }

    public BladeshroomCapEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(MidnightEntities.BLADESHROOM_CAP, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevSpin = this.spin;
        if (!this.field_70254_i) {
            this.spin += 25.0f;
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.035, 0.0));
            }
        }
    }

    protected void func_184549_a(RayTraceResult result) {
        try {
            HIT_ACTIVE.set(true);
            super.func_184549_a(result);
        }
        finally {
            HIT_ACTIVE.set(false);
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)MidnightItems.BLADESHROOM_CAP);
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundAtEntityEvent event) {
        if (!HIT_ACTIVE.get().booleanValue()) {
            return;
        }
        if (event.getSound() == SoundEvents.field_187731_t) {
            event.setSound(MidnightSounds.BLADESHROOM_CAP_HIT);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

