/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public abstract class GrowableEntity
extends CreatureEntity {
    private static final DataParameter<Integer> GROWING_AGE = EntityDataManager.func_187226_a(GrowableEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected int growingTime = 0;

    public GrowableEntity(EntityType<? extends GrowableEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public abstract int getMaxGrowingAge();

    public abstract int getGrowingTimeByAge();

    protected abstract void onGrowingToAge(int var1);

    @Nullable
    public abstract GrowableEntity createChild(GrowableEntity var1);

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWING_AGE, (Object)0);
    }

    public int getGrowingAge() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(GROWING_AGE, (Object)age);
        this.growingTime = 0;
        this.onGrowingToAge(age);
        this.func_213323_x_();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        float scale = 1.0f + (float)this.getGrowingAge() * 0.5f;
        return EntitySize.func_220314_b((float)(this.func_200600_R().func_220333_h() * scale), (float)(this.func_200600_R().func_220344_i() * scale));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("growing_age", this.getGrowingAge());
        compound.func_74768_a("growing_time", this.growingTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("growing_age", 3)) {
            this.setGrowingAge(compound.func_74762_e("growing_age"));
        }
        if (compound.func_150297_b("growing_time", 3)) {
            this.growingTime = compound.func_74762_e("growing_time");
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GROWING_AGE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public void func_70636_d() {
        super.func_70636_d();
        int growingAge = this.getGrowingAge();
        if (growingAge < this.getMaxGrowingAge() && ++this.growingTime >= this.getGrowingTimeByAge()) {
            this.setGrowingAge(++growingAge);
            this.growingTime -= this.getGrowingTimeByAge();
        }
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof SpawnEggItem && ((SpawnEggItem)stack.func_77973_b()).func_208077_a(stack.func_77978_p(), this.func_200600_R())) {
            GrowableEntity entity;
            if (!this.field_70170_p.field_72995_K && (entity = this.createChild(this)) != null) {
                entity.setGrowingAge(-1);
                entity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)entity);
                if (stack.func_82837_s()) {
                    entity.func_200203_b(stack.func_200301_q());
                }
                this.onChildSpawnFromEgg(player, entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    protected void onChildSpawnFromEgg(PlayerEntity playerIn, GrowableEntity child) {
    }
}

