/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.data.loot;

import com.mushroom.midnight.common.block.BladeshroomBlock;
import com.mushroom.midnight.common.block.SuavisBlock;
import com.mushroom.midnight.common.block.UnstableBushBloomedBlock;
import com.mushroom.midnight.common.data.loot.Conditions;
import com.mushroom.midnight.common.data.loot.MidnightLootTableProvider;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.AlternativesLootEntry;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.conditions.TableBonus;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.CopyName;
import net.minecraft.world.storage.loot.functions.ExplosionDecay;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import org.apache.commons.lang3.ArrayUtils;

public final class MidnightBlockLootProvider
extends MidnightLootTableProvider {
    private static final IRandomRange ONE = ConstantRange.func_215835_a((int)1);
    private final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public MidnightBlockLootProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void func_200398_a(DirectoryCache cache) {
        super.func_200398_a(cache);
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    @Override
    protected void addTables() {
        this.add(MidnightBlocks.SHADOWROOT_LOG);
        this.add(MidnightBlocks.SHADOWROOT_STRIPPED_LOG);
        this.add(MidnightBlocks.SHADOWROOT_PLANKS);
        this.add(MidnightBlocks.SHADOWROOT_WOOD);
        this.add(MidnightBlocks.SHADOWROOT_STRIPPED_WOOD);
        this.add(MidnightBlocks.DEAD_WOOD_LOG);
        this.add(MidnightBlocks.DEAD_WOOD_STRIPPED_LOG);
        this.add(MidnightBlocks.DEAD_WOOD_PLANKS);
        this.add(MidnightBlocks.DEAD_WOOD);
        this.add(MidnightBlocks.DEAD_WOOD_STRIPPED);
        this.add(MidnightBlocks.DARK_WILLOW_LOG);
        this.add(MidnightBlocks.DARK_WILLOW_STRIPPED_LOG);
        this.add(MidnightBlocks.DARK_WILLOW_PLANKS);
        this.add(MidnightBlocks.DARK_WILLOW_WOOD);
        this.add(MidnightBlocks.DARK_WILLOW_STRIPPED_WOOD);
        this.add(MidnightBlocks.NIGHTSTONE);
        this.add(MidnightBlocks.NIGHTSTONE_BRICKS);
        this.add(MidnightBlocks.CHISELED_NIGHTSTONE_BRICKS);
        this.add(MidnightBlocks.TRENCHSTONE);
        this.add(MidnightBlocks.TRENCHSTONE_BRICKS);
        this.add(MidnightBlocks.DARK_PEARL_BLOCK);
        this.add(MidnightBlocks.TENEBRUM_BLOCK);
        this.add(MidnightBlocks.NAGRILITE_ORE);
        this.add(MidnightBlocks.NAGRILITE_BLOCK);
        this.add(MidnightBlocks.EBONITE_BLOCK);
        this.add(MidnightBlocks.SHADOWROOT_CRAFTING_TABLE);
        this.add(MidnightBlocks.DARK_WILLOW_CRAFTING_TABLE);
        this.add(MidnightBlocks.DEAD_WOOD_CRAFTING_TABLE);
        this.add(MidnightBlocks.NIGHTSHROOM_CRAFTING_TABLE);
        this.add(MidnightBlocks.DEWSHROOM_CRAFTING_TABLE);
        this.add(MidnightBlocks.VIRIDSHROOM_CRAFTING_TABLE);
        this.add(MidnightBlocks.BOGSHROOM_CRAFTING_TABLE);
        this.add(MidnightBlocks.COARSE_DIRT);
        this.add(MidnightBlocks.DIRT);
        this.add(MidnightBlocks.NIGHTSHROOM);
        this.add(MidnightBlocks.NIGHTSHROOM_SHELF);
        this.add(MidnightBlocks.DEWSHROOM);
        this.add(MidnightBlocks.DEWSHROOM_SHELF);
        this.add(MidnightBlocks.DEWSHROOM_PLANKS);
        this.add(MidnightBlocks.VIRIDSHROOM);
        this.add(MidnightBlocks.VIRIDSHROOM_SHELF);
        this.add(MidnightBlocks.VIRIDSHROOM_PLANKS);
        this.add(MidnightBlocks.VIRIDSHROOM_STEM);
        this.add(MidnightBlocks.VIRIDSHROOM_ROOTS);
        this.add(MidnightBlocks.VIRIDSHROOM_FLOWERING_ROOTS);
        this.add(MidnightBlocks.NIGHTSHROOM_STEM);
        this.add(MidnightBlocks.NIGHTSHROOM_ROOTS);
        this.add(MidnightBlocks.NIGHTSHROOM_FLOWERING_ROOTS);
        this.add(MidnightBlocks.NIGHTSHROOM_PLANKS);
        this.add(MidnightBlocks.DEWSHROOM_STEM);
        this.add(MidnightBlocks.DEWSHROOM_ROOTS);
        this.add(MidnightBlocks.DEWSHROOM_FLOWERING_ROOTS);
        this.add(MidnightBlocks.BOGSHROOM);
        this.add(MidnightBlocks.BOGSHROOM_SHELF);
        this.add(MidnightBlocks.BOGSHROOM_STEM);
        this.add(MidnightBlocks.BOGSHROOM_PLANKS);
        this.add(MidnightBlocks.MISTSHROOM);
        this.add(MidnightBlocks.GLOB_FUNGUS);
        this.add(MidnightBlocks.ROCKSHROOM_BRICKS);
        this.add(MidnightBlocks.LUMEN_BUD);
        this.add(MidnightBlocks.TENDRILWEED);
        this.add(MidnightBlocks.RUNEBUSH);
        this.add(MidnightBlocks.DRAGON_NEST);
        this.add(MidnightBlocks.VIOLEAF);
        this.add(MidnightBlocks.CRYSTAL_FLOWER);
        this.add(MidnightBlocks.SHADOWROOT_SAPLING);
        this.add(MidnightBlocks.DARK_WILLOW_SAPLING);
        this.add(MidnightBlocks.SHADOWROOT_TRAPDOOR);
        this.add(MidnightBlocks.DEAD_WOOD_TRAPDOOR);
        this.add(MidnightBlocks.DARK_WILLOW_TRAPDOOR);
        this.add(MidnightBlocks.TENEBRUM_TRAPDOOR);
        this.add(MidnightBlocks.NIGHTSHROOM_TRAPDOOR);
        this.add(MidnightBlocks.DEWSHROOM_TRAPDOOR);
        this.add(MidnightBlocks.VIRIDSHROOM_TRAPDOOR);
        this.add(MidnightBlocks.BOGSHROOM_TRAPDOOR);
        this.add(MidnightBlocks.BLOOMCRYSTAL);
        this.add(MidnightBlocks.BLOOMCRYSTAL_ROCK);
        this.add(MidnightBlocks.ROUXE);
        this.add(MidnightBlocks.ROUXE_ROCK);
        this.add(MidnightBlocks.MIASMA_SURFACE);
        this.add(MidnightBlocks.DECEITFUL_PEAT);
        this.add(MidnightBlocks.DECEITFUL_MUD);
        this.add(MidnightBlocks.DECEITFUL_ALGAE);
        this.add(MidnightBlocks.DECEITFUL_MOSS);
        this.add(MidnightBlocks.SHADOWROOT_STAIRS);
        this.add(MidnightBlocks.DEAD_WOOD_STAIRS);
        this.add(MidnightBlocks.DARK_WILLOW_STAIRS);
        this.add(MidnightBlocks.NIGHTSTONE_STAIRS);
        this.add(MidnightBlocks.NIGHTSTONE_BRICK_STAIRS);
        this.add(MidnightBlocks.TRENCHSTONE_STAIRS);
        this.add(MidnightBlocks.TRENCHSTONE_BRICK_STAIRS);
        this.add(MidnightBlocks.DEWSHROOM_STAIRS);
        this.add(MidnightBlocks.VIRIDSHROOM_STAIRS);
        this.add(MidnightBlocks.BOGSHROOM_STAIRS);
        this.add(MidnightBlocks.NIGHTSHROOM_STAIRS);
        this.add(MidnightBlocks.ROCKSHROOM_BRICK_STAIRS);
        this.add(MidnightBlocks.SHADOWROOT_FENCE);
        this.add(MidnightBlocks.DEAD_WOOD_FENCE);
        this.add(MidnightBlocks.DARK_WILLOW_FENCE);
        this.add(MidnightBlocks.NIGHTSTONE_WALL);
        this.add(MidnightBlocks.NIGHTSTONE_BRICK_WALL);
        this.add(MidnightBlocks.TRENCHSTONE_WALL);
        this.add(MidnightBlocks.TRENCHSTONE_BRICK_WALL);
        this.add(MidnightBlocks.ROCKSHROOM_BRICK_WALL);
        this.add(MidnightBlocks.DEWSHROOM_FENCE);
        this.add(MidnightBlocks.VIRIDSHROOM_FENCE);
        this.add(MidnightBlocks.BOGSHROOM_FENCE);
        this.add(MidnightBlocks.NIGHTSHROOM_FENCE);
        this.add(MidnightBlocks.SHADOWROOT_FENCE_GATE);
        this.add(MidnightBlocks.DEAD_WOOD_FENCE_GATE);
        this.add(MidnightBlocks.DARK_WILLOW_FENCE_GATE);
        this.add(MidnightBlocks.DEWSHROOM_FENCE_GATE);
        this.add(MidnightBlocks.VIRIDSHROOM_FENCE_GATE);
        this.add(MidnightBlocks.BOGSHROOM_FENCE_GATE);
        this.add(MidnightBlocks.NIGHTSHROOM_FENCE_GATE);
        this.add(MidnightBlocks.SHADOWROOT_LADDER);
        this.add(MidnightBlocks.DEAD_WOOD_LADDER);
        this.add(MidnightBlocks.DARK_WILLOW_LADDER);
        this.add(MidnightBlocks.DEWSHROOM_LADDER);
        this.add(MidnightBlocks.VIRIDSHROOM_LADDER);
        this.add(MidnightBlocks.BOGSHROOM_LADDER);
        this.add(MidnightBlocks.NIGHTSHROOM_LADDER);
        this.add(MidnightBlocks.CRYSTALOTUS);
        this.add(MidnightBlocks.SHADOWROOT_BUTTON);
        this.add(MidnightBlocks.DEAD_WOOD_BUTTON);
        this.add(MidnightBlocks.DARK_WILLOW_BUTTON);
        this.add(MidnightBlocks.DEWSHROOM_BUTTON);
        this.add(MidnightBlocks.VIRIDSHROOM_BUTTON);
        this.add(MidnightBlocks.BOGSHROOM_BUTTON);
        this.add(MidnightBlocks.NIGHTSHROOM_BUTTON);
        this.add(MidnightBlocks.NIGHTSTONE_BUTTON);
        this.add(MidnightBlocks.TRENCHSTONE_BUTTON);
        this.add(MidnightBlocks.ROCKSHROOM_BRICK_BUTTON);
        this.add(MidnightBlocks.SHADOWROOT_PRESSURE_PLATE);
        this.add(MidnightBlocks.DEAD_WOOD_PRESSURE_PLATE);
        this.add(MidnightBlocks.DARK_WILLOW_PRESSURE_PLATE);
        this.add(MidnightBlocks.DEWSHROOM_PRESSURE_PLATE);
        this.add(MidnightBlocks.VIRIDSHROOM_PRESSURE_PLATE);
        this.add(MidnightBlocks.BOGSHROOM_PRESSURE_PLATE);
        this.add(MidnightBlocks.NIGHTSHROOM_PRESSURE_PLATE);
        this.add(MidnightBlocks.NIGHTSTONE_PRESSURE_PLATE);
        this.add(MidnightBlocks.TRENCHSTONE_PRESSURE_PLATE);
        this.add(MidnightBlocks.ROCKSHROOM_BRICK_PRESSURE_PLATE);
        this.add(MidnightBlocks.NAGRILITE_PRESSURE_PLATE);
        this.add(MidnightBlocks.TENEBRUM_PRESSURE_PLATE);
        this.add(MidnightBlocks.MIDNIGHT_LEVER);
        this.add(MidnightBlocks.TENEBRUM_ORE);
        this.add(MidnightBlocks.GLOB_FUNGUS_HAT);
        this.add(MidnightBlocks.MALIGNANT_BLUE_PLANT_BLOCK);
        this.add(MidnightBlocks.MALIGNANT_RED_PLANT_BLOCK);
        this.add(MidnightBlocks.MALIGNANT_PURPLE_PLANT_BLOCK);
        this.add(MidnightBlocks.MALIGNANT_GREEN_PLANT_BLOCK);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_BLUE_PLANT_BLOCK);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_RED_PLANT_BLOCK);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_PURPLE_PLANT_BLOCK);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_GREEN_PLANT_BLOCK);
        this.add(MidnightBlocks.MALIGNANT_BLUE_HANGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_RED_HANGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_PURPLE_HANGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_GREEN_HANGING_VINES);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_BLUE_HANGING_VINES);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_RED_HANGING_VINES);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_PURPLE_HANGING_VINES);
        this.add(MidnightBlocks.GLOWING_MALIGNANT_GREEN_HANGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_BLUE_PLANT_SURFACE);
        this.add(MidnightBlocks.MALIGNANT_RED_PLANT_SURFACE);
        this.add(MidnightBlocks.MALIGNANT_PURPLE_PLANT_SURFACE);
        this.add(MidnightBlocks.MALIGNANT_GREEN_PLANT_SURFACE);
        this.add(MidnightBlocks.MALIGNANT_BLUE_BRIDGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_RED_BRIDGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_PURPLE_BRIDGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_GREEN_BRIDGING_VINES);
        this.add(MidnightBlocks.MALIGNANT_FOXGLOVE);
        this.add(MidnightBlocks.MALIGNANT_HEMLOCK);
        this.add(MidnightBlocks.MALIGNANT_HYACINTH);
        this.add(MidnightBlocks.MALIGNANT_IVY);
        this.add(MidnightBlocks.MALIGNANT_LARKSPUR);
        this.add(MidnightBlocks.MALIGNANT_LILY);
        this.add(MidnightBlocks.MALIGNANT_MANDRAKE);
        this.add(MidnightBlocks.MALIGNANT_MOONSEED);
        this.add(MidnightBlocks.MALIGNANT_NETTLE);
        this.add(MidnightBlocks.MALIGNANT_RAGWEED);
        this.add(MidnightBlocks.MALIGNANT_SNAKEROOT);
        this.add(MidnightBlocks.MALIGNANT_SPINDLE);
        this.add(MidnightBlocks.MALIGNANT_TAILFLOWER);
        this.add(MidnightBlocks.MALIGNANT_THISTLE);
        this.add(MidnightBlocks.MALIGNANT_WALLFLOWER);
        this.add(MidnightBlocks.MALIGNANT_WOLFSBANE);
        this.addDoubleBlock(MidnightBlocks.MALIGNANT_BANEBERRY);
        this.addDoubleBlock(MidnightBlocks.MALIGNANT_BLOODROOT);
        this.addDoubleBlock(MidnightBlocks.MALIGNANT_NIGHTSHADE);
        this.addDoubleBlock(MidnightBlocks.MALIGNANT_WISTERIA);
        this.add(MidnightBlocks.BOGSHROOM_SPORCH);
        this.add(MidnightBlocks.NIGHTSHROOM_SPORCH);
        this.add(MidnightBlocks.DEWSHROOM_SPORCH);
        this.add(MidnightBlocks.VIRIDSHROOM_SPORCH);
        this.add(MidnightBlocks.BOGSHROOM_WALL_SPORCH, (IItemProvider)MidnightBlocks.BOGSHROOM_SPORCH);
        this.add(MidnightBlocks.NIGHTSHROOM_WALL_SPORCH, (IItemProvider)MidnightBlocks.NIGHTSHROOM_SPORCH);
        this.add(MidnightBlocks.DEWSHROOM_WALL_SPORCH, (IItemProvider)MidnightBlocks.DEWSHROOM_SPORCH);
        this.add(MidnightBlocks.VIRIDSHROOM_WALL_SPORCH, (IItemProvider)MidnightBlocks.VIRIDSHROOM_SPORCH);
        this.addSheared(MidnightBlocks.BOGWEED);
        this.addSheared(MidnightBlocks.GHOST_PLANT);
        this.addSheared(MidnightBlocks.FINGERED_GRASS);
        this.addSheared(MidnightBlocks.GRASS);
        this.addSheared(MidnightBlocks.HANGING_DARK_WILLOW_LEAVES);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_NIGHTSHROOM);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_DEWSHROOM);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_VIRIDSHROOM);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_BOGSHROOM);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_MISTSHROOM);
        this.addDoubleBlock(MidnightBlocks.DOUBLE_LUMEN_BUD);
        this.addShearedDoubleBlock(MidnightBlocks.TALL_GRASS);
        this.addDoubleBlock(MidnightBlocks.SHADOWROOT_DOOR);
        this.addDoubleBlock(MidnightBlocks.DEAD_WOOD_DOOR);
        this.addDoubleBlock(MidnightBlocks.DARK_WILLOW_DOOR);
        this.addDoubleBlock(MidnightBlocks.TENEBRUM_DOOR);
        this.addDoubleBlock(MidnightBlocks.NIGHTSHROOM_DOOR);
        this.addDoubleBlock(MidnightBlocks.DEWSHROOM_DOOR);
        this.addDoubleBlock(MidnightBlocks.VIRIDSHROOM_DOOR);
        this.addDoubleBlock(MidnightBlocks.BOGSHROOM_DOOR);
        this.addSilkTouched(MidnightBlocks.ARCHAIC_GLASS);
        this.addSilkTouched(MidnightBlocks.ARCHAIC_GLASS_PANE);
        this.addSlab(MidnightBlocks.SHADOWROOT_SLAB);
        this.addSlab(MidnightBlocks.DEAD_WOOD_SLAB);
        this.addSlab(MidnightBlocks.DARK_WILLOW_SLAB);
        this.addSlab(MidnightBlocks.NIGHTSTONE_SLAB);
        this.addSlab(MidnightBlocks.NIGHTSTONE_BRICK_SLAB);
        this.addSlab(MidnightBlocks.TRENCHSTONE_SLAB);
        this.addSlab(MidnightBlocks.TRENCHSTONE_BRICK_SLAB);
        this.addSlab(MidnightBlocks.DEWSHROOM_SLAB);
        this.addSlab(MidnightBlocks.VIRIDSHROOM_SLAB);
        this.addSlab(MidnightBlocks.BOGSHROOM_SLAB);
        this.addSlab(MidnightBlocks.NIGHTSHROOM_SLAB);
        this.addSlab(MidnightBlocks.ROCKSHROOM_BRICK_SLAB);
        this.addFungiHat(MidnightBlocks.VIRIDSHROOM_HAT, (IItemProvider)MidnightBlocks.VIRIDSHROOM, (IItemProvider)MidnightItems.VIRIDSHROOM_POWDER);
        this.addFungiHat(MidnightBlocks.NIGHTSHROOM_HAT, (IItemProvider)MidnightBlocks.NIGHTSHROOM, (IItemProvider)MidnightItems.NIGHTSHROOM_POWDER);
        this.addFungiHat(MidnightBlocks.DEWSHROOM_HAT, (IItemProvider)MidnightBlocks.DEWSHROOM, (IItemProvider)MidnightItems.DEWSHROOM_POWDER);
        this.addFungiHat(MidnightBlocks.BOGSHROOM_HAT, (IItemProvider)MidnightBlocks.BOGSHROOM, (IItemProvider)MidnightItems.BOGSHROOM_POWDER);
        this.addSilkTouchedAlternative(MidnightBlocks.GRASS_BLOCK, (IItemProvider)MidnightBlocks.DIRT);
        this.addSilkTouchedAlternative(MidnightBlocks.MYCELIUM, (IItemProvider)MidnightBlocks.NIGHTSTONE);
        this.addGem(MidnightBlocks.DARK_PEARL_ORE, (IItemProvider)MidnightItems.GEODE);
        this.addGem(MidnightBlocks.ARCHAIC_ORE, (IItemProvider)MidnightItems.ARCHAIC_SHARD);
        this.addGem(MidnightBlocks.EBONITE_ORE, (IItemProvider)MidnightItems.EBONITE);
        this.add(MidnightBlocks.UNSTABLE_BUSH, (IItemProvider)MidnightItems.UNSTABLE_SEEDS);
        this.addUnstableBush(MidnightBlocks.UNSTABLE_BUSH_BLUE_BLOOMED, (IItemProvider)MidnightItems.BLUE_UNSTABLE_FRUIT);
        this.addUnstableBush(MidnightBlocks.UNSTABLE_BUSH_GREEN_BLOOMED, (IItemProvider)MidnightItems.GREEN_UNSTABLE_FRUIT);
        this.addUnstableBush(MidnightBlocks.UNSTABLE_BUSH_LIME_BLOOMED, (IItemProvider)MidnightItems.LIME_UNSTABLE_FRUIT);
        this.addLeaves(MidnightBlocks.SHADOWROOT_LEAVES, (IItemProvider)MidnightBlocks.SHADOWROOT_SAPLING);
        this.addLeaves(MidnightBlocks.DARK_WILLOW_LEAVES, (IItemProvider)MidnightBlocks.DARK_WILLOW_SAPLING);
        this.add(MidnightBlocks.SHADOWROOT_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.DARK_WILLOW_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.DEAD_WOOD_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.NIGHTSHROOM_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.DEWSHROOM_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.VIRIDSHROOM_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.BOGSHROOM_CHEST, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.NIGHTSTONE_FURNACE, MidnightBlockLootProvider::copyName);
        this.add(MidnightBlocks.BLADESHROOM, (Block block) -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.BLADESHROOM_CAP).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(BladeshroomBlock.STAGE, (Comparable)((Object)BladeshroomBlock.Stage.CAPPED))))).func_216045_a((LootEntry.Builder)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.BLADESHROOM_SPORES).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(BladeshroomBlock.STAGE, (Comparable)((Object)BladeshroomBlock.Stage.CAPPED)))), ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.BLADESHROOM_SPORES).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))}))));
        this.add(MidnightBlocks.SUAVIS, (Block block) -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(Conditions.HAS_SILK_TOUCH)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)SuavisBlock.STAGE, 3))), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.RAW_SUAVIS).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)SuavisBlock.STAGE, 3)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f))), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.RAW_SUAVIS).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)SuavisBlock.STAGE, 2)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))), ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.RAW_SUAVIS).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)SuavisBlock.STAGE, 1)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))}))));
        this.addWithCountAndBonus(MidnightBlocks.GLOB_FUNGUS_STEM, (IItemProvider)MidnightItems.GLOB_FUNGUS_HAND, (IRandomRange)ConstantRange.func_215835_a((int)4));
        this.addWithCountAndBonus(MidnightBlocks.ROCKSHROOM, (IItemProvider)MidnightItems.ROCKSHROOM_CLUMP, (IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f));
    }

    private static <T> T explosionDecay(ILootFunctionConsumer<T> consumer) {
        return (T)consumer.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
    }

    private static <T> T checkExplosion(ILootConditionConsumer<T> consumer) {
        return (T)consumer.func_212840_b_(SurvivesExplosion.func_215968_b());
    }

    private static LootTable.Builder drop(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)MidnightBlockLootProvider.checkExplosion(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item))));
    }

    private static LootTable.Builder dropIf(IItemProvider item, ILootCondition.IBuilder condition) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)MidnightBlockLootProvider.checkExplosion(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)).func_212840_b_(condition)));
    }

    private static LootTable.Builder selfOrAlternatives(Block block, ILootCondition.IBuilder condition, LootEntry.Builder<?> ... alternatives) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)new AlternativesLootEntry.Builder((LootEntry.Builder[])ArrayUtils.insert((int)0, (Object[])alternatives, (Object[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(condition)}))));
    }

    private static LootTable.Builder silkTouched(Block block, LootEntry.Builder<?> ... alternatives) {
        return MidnightBlockLootProvider.selfOrAlternatives(block, Conditions.HAS_SILK_TOUCH, alternatives);
    }

    private static LootTable.Builder silkOrSheared(Block block, LootEntry.Builder<?> ... alternatives) {
        return MidnightBlockLootProvider.selfOrAlternatives(block, Conditions.HAS_SHEARS_OR_SILK_TOUCH, alternatives);
    }

    private static LootTable.Builder copyName(Block block) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)MidnightBlockLootProvider.checkExplosion(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)))));
    }

    private void add(Block block, Function<Block, LootTable.Builder> function) {
        this.add(block, function.apply(block));
    }

    private void add(Block block, LootTable.Builder table) {
        this.lootTables.put(block, table);
    }

    private void add(Block block, IItemProvider item) {
        this.add(block, MidnightBlockLootProvider.drop(item));
    }

    private void add(Block block) {
        this.add(block, (IItemProvider)block);
    }

    private void addSilkTouchedAlternative(Block block, IItemProvider drop) {
        this.add(block, MidnightBlockLootProvider.silkTouched(block, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)drop)}));
    }

    private void addSilkTouched(Block block) {
        this.add(block, MidnightBlockLootProvider.dropIf((IItemProvider)block, Conditions.HAS_SILK_TOUCH));
    }

    private void addSheared(Block block, IItemProvider drop) {
        this.add(block, MidnightBlockLootProvider.dropIf(drop, Conditions.HAS_SHEARS));
    }

    private void addSheared(Block block) {
        this.addSheared(block, (IItemProvider)block);
    }

    private void addSlab(Block block) {
        BlockStateProperty.Builder isDouble = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE));
        LootFunction.Builder doubleFunction = SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)isDouble);
        LootTable.Builder table = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)MidnightBlockLootProvider.explosionDecay(ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)doubleFunction))).func_216046_a(ONE));
        this.add(block, table);
    }

    private void addGem(Block block, IItemProvider gem) {
        LootTable.Builder table = MidnightBlockLootProvider.silkTouched(block, (LootEntry.Builder)MidnightBlockLootProvider.explosionDecay(ItemLootEntry.func_216168_a((IItemProvider)gem).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))));
        this.add(block, table);
    }

    private void addFungiHat(Block block, IItemProvider fungi, IItemProvider powder) {
        this.add(block, (LootTable.Builder)MidnightBlockLootProvider.explosionDecay(MidnightBlockLootProvider.silkTouched(block, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)fungi).func_212840_b_(RandomChance.func_216004_a((float)0.5f)), ItemLootEntry.func_216168_a((IItemProvider)powder)})));
    }

    private void addUnstableBush(Block block, IItemProvider fruit) {
        BlockStateProperty.Builder condition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((IProperty)UnstableBushBloomedBlock.HAS_FRUIT, true));
        RandomValueRange count = RandomValueRange.func_215837_a((float)3.0f, (float)6.0f);
        this.add(block, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)condition).func_216045_a((LootEntry.Builder)MidnightBlockLootProvider.explosionDecay(ItemLootEntry.func_216168_a((IItemProvider)fruit).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)count)))).func_216046_a(ONE)));
    }

    private void addLeaves(Block block, IItemProvider sapling) {
        LootTable.Builder table = MidnightBlockLootProvider.silkOrSheared(block, ((StandaloneLootEntry.Builder)MidnightBlockLootProvider.checkExplosion(ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.05f, 0.0625f, 0.08f, 0.1f}))).func_216040_a(LootPool.func_216096_a().func_212840_b_(Conditions.NOT_SHEARS_OR_SILK_TOUCH).func_216045_a(((StandaloneLootEntry.Builder)MidnightBlockLootProvider.explosionDecay(ItemLootEntry.func_216168_a((IItemProvider)MidnightItems.DARK_STICK).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.02f, 0.025f, 0.03f, 0.1f}))).func_216046_a(ONE));
        this.add(block, table);
    }

    private void addDoubleBlock(Block block) {
        LootTable.Builder table = LootTable.func_216119_b().func_216040_a((LootPool.Builder)MidnightBlockLootProvider.checkExplosion(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.LOWER)))));
        this.add(block, table);
    }

    private void addShearedDoubleBlock(Block block) {
        LootTable.Builder table = LootTable.func_216119_b().func_216040_a((LootPool.Builder)MidnightBlockLootProvider.checkExplosion(LootPool.func_216096_a().func_216046_a(ONE).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.LOWER))).func_212840_b_(Conditions.HAS_SHEARS)));
        this.add(block, table);
    }

    private void addWithCountAndBonus(Block block, IItemProvider item, IRandomRange count) {
        LootTable.Builder table = MidnightBlockLootProvider.silkTouched(block, (LootEntry.Builder)MidnightBlockLootProvider.explosionDecay(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)count)).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))));
        this.add(block, table);
    }

    @Override
    public String func_200397_b() {
        return "Midnight BlockLootTables";
    }
}

