/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.capability;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.network.AnimationMessage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class AnimationCapability
implements ICapabilityProvider {
    private Type animationType = Type.NONE;
    private int maxTicks;
    private int prevTick;
    private int currentTick;

    public void setAnimation(Entity animatable, Type animationType, int duration) {
        this.animationType = animationType;
        this.maxTicks = duration;
        this.currentTick = 0;
        if (!animatable.field_70170_p.field_72995_K) {
            AnimationMessage message = new AnimationMessage(animatable, animationType, duration);
            Midnight.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> animatable), (Object)message);
        }
    }

    public Type getAnimationType() {
        return this.animationType;
    }

    public int getDuration() {
        return this.maxTicks;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public float getProgress(float partialTicks) {
        return ((float)this.prevTick + (float)(this.currentTick - this.prevTick) * partialTicks) / (float)this.maxTicks;
    }

    public void updateAnimation() {
        if (this.animationType != Type.NONE) {
            this.prevTick = this.currentTick;
            if (this.currentTick >= this.maxTicks) {
                this.maxTicks = 0;
                this.currentTick = 0;
                this.animationType = Type.NONE;
            } else {
                ++this.currentTick;
            }
        }
    }

    public void resetAnimation(Entity animable) {
        this.setAnimation(animable, Type.NONE, 0);
    }

    public boolean isAnimate() {
        return this.animationType != Type.NONE;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return Midnight.ANIMATION_CAP.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public static enum Type {
        NONE,
        ATTACK,
        EAT,
        CURTSEY,
        CHARGE;

    }
}

