/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.RiftTraveller;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.creature.RifterEntity;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.registry.MidnightTileEntities;
import com.mushroom.midnight.common.tile.RiftPortalTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RiftPortalBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public RiftPortalBlock(Block.Properties properties) {
        super(properties);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof RiftPortalTileEntity && !((RiftPortalTileEntity)tileEntity).isClosed()) {
            if (rand.nextInt(30) == 0) {
                worldIn.func_184133_a(null, pos, MidnightSounds.RIFT_IDLE, SoundCategory.BLOCKS, 2.0f, 0.95f + rand.nextFloat() * 0.1f);
            }
            if (rand.nextInt(15) == 0) {
                worldIn.func_184133_a(null, pos, MidnightSounds.RIFT_IDLE, SoundCategory.BLOCKS, 2.0f, 0.95f + rand.nextFloat() * 0.1f);
                worldIn.func_195594_a((IParticleData)MidnightParticleTypes.SPORE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)rand.nextFloat() - 0.5, (double)(rand.nextFloat() * 1.2f), (double)rand.nextFloat() - 0.5);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return RiftPortalBlock.isClosed(world, pos) ? SHAPE : VoxelShapes.func_197880_a();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int config = (Integer)MidnightConfig.logic.rifterSpawnRarity.get();
        if (config > 0 && !worldIn.func_72935_r() && worldIn.field_73011_w.func_76569_d() && worldIn.func_82736_K().func_223586_b(GameRules.field_223601_d) && rand.nextInt(config) < worldIn.func_175659_aa().func_151525_a() && worldIn.func_175647_a(RifterEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - 20), (double)(pos.func_177956_o() - 10), (double)(pos.func_177952_p() - 20), (double)(pos.func_177958_n() + 21), (double)(pos.func_177956_o() + 31), (double)(pos.func_177952_p() + 21)), null).size() < (Integer)MidnightConfig.logic.maxRifterByRift.get()) {
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    BlockPos spawnPos = pos.func_177982_a(i, 0, j);
                    if (worldIn.func_180495_p(spawnPos).func_177230_c() == this || !worldIn.func_180495_p(spawnPos.func_177984_a()).func_196958_f() || !worldIn.func_180495_p(spawnPos.func_177981_b(2)).func_196958_f()) continue;
                    RifterEntity entity = (RifterEntity)MidnightEntities.RIFTER.func_220342_a((World)worldIn, null, null, null, spawnPos.func_177984_a(), SpawnReason.STRUCTURE, false, false);
                    if (entity != null) {
                        entity.spawnedThroughRift = true;
                        entity.setRiftPosition(pos);
                    }
                    return;
                }
            }
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(state, world, pos, entity);
        if (entity.func_226278_cu_() >= (double)pos.func_177956_o() + 0.9375) {
            return;
        }
        if (RiftPortalBlock.isClosed((IBlockReader)world, pos)) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
            return;
        }
        if (entity instanceof RifterEntity && ((RifterEntity)entity).hasCaptured()) {
            return;
        }
        entity.getCapability(Midnight.RIFT_TRAVELLER_CAP).ifPresent(RiftTraveller::setInRift);
    }

    private static boolean isClosed(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof RiftPortalTileEntity) {
            RiftPortalTileEntity riftEntity = (RiftPortalTileEntity)tileEntity;
            return riftEntity.isClosed();
        }
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return MidnightTileEntities.RIFT_PORTAL.func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

