/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.util.MidnightUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class PileOfEggsBlock
extends Block {
    public static final SoundType PILE_OF_EGGS = new SoundType(1.0f, 1.0f, MidnightSounds.EGG_CRACKED, SoundEvents.field_187902_gb, SoundEvents.field_187845_fY, SoundEvents.field_187843_fX, SoundEvents.field_187841_fW);
    protected static final VoxelShape BOUND_ONE_EGG = PileOfEggsBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    protected static final VoxelShape BOUND_SEVERAL_EGGS = PileOfEggsBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty EGGS = BlockStateProperties.field_208127_ab;

    protected PileOfEggsBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(PILE_OF_EGGS).func_200948_a(-1.0f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)EGGS, (Comparable)Integer.valueOf(1)));
    }

    protected abstract MobEntity createEntityForEgg(World var1, BlockPos var2, BlockState var3);

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            if ((Integer)state.func_177229_b((IProperty)EGGS) < 4 && !player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                if (!player.field_70170_p.field_72995_K) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)EGGS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)EGGS) + 1)));
                    world.func_184133_a(null, pos, this.field_149762_H.func_185841_e(), SoundCategory.BLOCKS, (this.field_149762_H.func_185843_a() + 1.0f) / 2.0f, this.field_149762_H.func_185847_b() * 0.8f);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (this.canTrample(world, entity)) {
            this.onTrample(world, pos, 0.05f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (this.canTrample(world, entity)) {
            this.onTrample(world, pos, 1.0f);
        }
    }

    protected boolean canTrample(World world, Entity trampler) {
        return trampler instanceof PlayerEntity || trampler instanceof LivingEntity && !trampler.func_200600_R().equals(MidnightEntities.STINGER) && ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)trampler);
    }

    protected void onTrample(World world, BlockPos pos, float chance) {
        if (!world.field_72995_K && (chance >= 1.0f || world.field_73012_v.nextFloat() <= chance)) {
            this.breakEggs(world, pos, world.func_180495_p(pos));
        }
    }

    protected void breakEggs(World world, BlockPos pos, BlockState state) {
        MobEntity creature;
        if (world.field_72995_K) {
            return;
        }
        if (!(state.func_177230_c() instanceof PileOfEggsBlock)) {
            return;
        }
        world.func_184133_a(null, pos, PILE_OF_EGGS.func_185845_c(), SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        int eggs = (Integer)state.func_177229_b((IProperty)EGGS);
        if (eggs <= 1) {
            world.func_175655_b(pos, false);
        } else {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)EGGS, (Comparable)Integer.valueOf(--eggs)), 2);
            world.func_217379_c(2001, pos, PileOfEggsBlock.func_196246_j((BlockState)state));
        }
        try {
            creature = this.createEntityForEgg(world, pos, state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        creature.func_70012_b((double)pos.func_177958_n() - 0.5 + (double)world.field_73012_v.nextFloat(), (double)((float)pos.func_177956_o() + 0.45f), (double)pos.func_177952_p() - 0.5 + (double)world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)creature);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity tile, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        float chance = (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 ? 0.6f : 0.2f) + 0.1f * (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
        if (world.field_73012_v.nextFloat() <= chance) {
            MidnightUtil.spawnItemStack(world, pos, this);
        } else {
            this.breakEggs(world, pos, state);
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((IProperty)EGGS) > 1 ? BOUND_SEVERAL_EGGS : BOUND_ONE_EGG;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{EGGS});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }
}

