/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class MidnightStairsBlock
extends StairsBlock {
    private final Supplier<BlockState> stateSupplier;

    public MidnightStairsBlock(Supplier<BlockState> stateSupplier, Block.Properties properties) {
        super(Blocks.field_150350_a.func_176223_P(), properties);
        this.stateSupplier = stateSupplier;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_196954_c(worldIn, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.stateSupplier.get().func_177230_c().func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.stateSupplier.get().func_196942_a(worldIn, pos, player);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        this.stateSupplier.get().func_177230_c().func_176206_d(worldIn, pos, state);
    }

    public float func_149638_a() {
        return this.stateSupplier.get().func_177230_c().func_149638_a();
    }

    public int func_149738_a(IWorldReader worldIn) {
        return this.stateSupplier.get().func_177230_c().func_149738_a(worldIn);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            BlockState currentState = this.stateSupplier.get();
            currentState.func_215697_a(worldIn, pos, Blocks.field_150350_a, pos, false);
            currentState.func_177230_c().func_220082_b(currentState, worldIn, pos, oldState, false);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.stateSupplier.get().func_196947_b(worldIn, pos, newState, isMoving);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.stateSupplier.get().func_177230_c().func_176199_a(worldIn, pos, entityIn);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.stateSupplier.get().func_177230_c().func_225534_a_(state, worldIn, pos, random);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.stateSupplier.get().func_227031_a_(worldIn, player, handIn, hit);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.stateSupplier.get().func_177230_c().func_180652_a(worldIn, pos, explosionIn);
    }

    public int getHarvestLevel(BlockState state) {
        return this.stateSupplier.get().getHarvestLevel();
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return this.stateSupplier.get().getHarvestTool();
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.stateSupplier.get().func_177230_c().getFireSpreadSpeed(state, world, pos, face);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.stateSupplier.get().func_177230_c().getFlammability(state, world, pos, face);
    }
}

