/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.GeneratablePlant;
import com.mushroom.midnight.common.block.MidnightDoublePlantBlock;
import com.mushroom.midnight.common.registry.MidnightTags;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MidnightPlantBlock
extends BushBlock
implements IGrowable,
GeneratablePlant {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    @Nullable
    protected final Supplier<Block> growSupplier;
    private final boolean glowing;
    private boolean replaceable;

    public MidnightPlantBlock(Block.Properties properties) {
        this(properties, false, null);
    }

    public MidnightPlantBlock(Block.Properties properties, boolean glowing) {
        this(properties, glowing, null);
    }

    public MidnightPlantBlock(Block.Properties properties, boolean glowing, @Nullable Supplier<Block> growSupplier) {
        super(properties.func_200951_a(glowing ? 12 : 0));
        this.glowing = glowing;
        this.growSupplier = growSupplier;
    }

    public MidnightPlantBlock setReplaceable() {
        this.replaceable = true;
        return this;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c().func_203417_a(MidnightTags.Blocks.PLANTABLE_GROUNDS);
    }

    @Override
    public boolean canGeneratePlant(World world, BlockPos pos, BlockState state) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(MidnightTags.Blocks.PLANTABLE_GROUNDS);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        return this.replaceable;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 100;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.growSupplier != null;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return this.growSupplier != null;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        BlockState plantState;
        if (this.growSupplier != null && (plantState = this.growSupplier.get().func_176223_P()).func_196955_c((IWorldReader)world, pos) && world.func_175623_d(pos.func_177984_a())) {
            MidnightDoublePlantBlock.placeAt((IWorld)world, pos, plantState, 2);
        }
    }
}

