/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MidnightFungiHatBlock
extends Block {
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");

    public MidnightFungiHatBlock(MaterialColor materialColor) {
        super(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)materialColor).func_200947_a(SoundType.field_185848_a).func_200948_a(0.5f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ) {
            BooleanProperty faceProperty;
            if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)(faceProperty = MidnightFungiHatBlock.getFaceProperty(hitResult.func_216354_b())))).booleanValue()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)faceProperty, (Comparable)Boolean.valueOf(true)), 11);
                world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hitResult);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        MidnightFungiHatBlock.placeFungiInsides(world, state, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        MidnightFungiHatBlock.placeFungiInsides(world, state, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.8f;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
        boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(south));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(east));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(north));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
        boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(north));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(east));
            }
        }
        return state;
    }

    private static void placeFungiInsides(World world, BlockState state, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BooleanProperty property = MidnightFungiHatBlock.getFaceProperty(direction);
            if (!((Boolean)state.func_177229_b((IProperty)property)).booleanValue()) continue;
            MidnightFungiHatBlock.placeFungiInside(world, pos, direction);
        }
    }

    private static void placeFungiInside(World world, BlockPos pos, Direction direction) {
        BlockPos insidePos = pos.func_177972_a(direction);
        if (world.func_175623_d(insidePos)) {
            world.func_175656_a(insidePos, MidnightBlocks.FUNGI_INSIDE.func_176223_P());
        }
    }

    private static BooleanProperty getFaceProperty(Direction direction) {
        switch (direction) {
            case DOWN: {
                return DOWN;
            }
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new Error();
    }
}

