/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome.surface;

import com.mushroom.midnight.common.biome.ConfigurableBiome;
import com.mushroom.midnight.common.world.MidnightChunkGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public abstract class SurfaceBiome
extends Biome
implements ConfigurableBiome {
    private final float ridgeWeight;
    private final float densityScale;
    private final int grassColor;
    private final int foliageColor;
    private final int skyColor;
    private final float fogStart;
    private final float fogEnd;

    protected SurfaceBiome(Properties properties) {
        super((Biome.Builder)properties);
        this.ridgeWeight = properties.ridgeWeight;
        this.densityScale = properties.densityScale;
        this.grassColor = properties.grassColor;
        this.foliageColor = properties.foliageColor;
        this.skyColor = properties.skyColor;
        this.fogStart = properties.fogStart;
        this.fogEnd = properties.fogEnd;
    }

    public boolean func_201848_a(IWorldReader world, BlockPos pos) {
        return false;
    }

    public int func_225528_a_(double p_225528_1_, double p_225528_3_) {
        return this.grassColor;
    }

    public int func_225527_a_() {
        return this.foliageColor;
    }

    public float getRidgeWeight() {
        return this.ridgeWeight;
    }

    public float getDensityScale() {
        return this.densityScale;
    }

    public int func_225529_c_() {
        return this.skyColor;
    }

    public float getFogStart() {
        return this.fogStart;
    }

    public float getFogEnd() {
        return this.fogEnd;
    }

    public int getSkyColorByTemp(float temperature) {
        return this.skyColor;
    }

    @Override
    public void add(GenerationStage.Decoration stage, ConfiguredFeature feature) {
        super.func_203611_a(stage, feature);
    }

    @Override
    public <C extends ICarverConfig> void add(GenerationStage.Carving stage, ConfiguredCarver<C> carver) {
        super.func_203609_a(stage, carver);
    }

    @Override
    public <C extends IFeatureConfig> void add(ConfiguredFeature<C, ? extends Structure<C>> structure) {
        super.func_226711_a_(structure);
    }

    @Override
    public void add(EntityClassification classification, Biome.SpawnListEntry entry) {
        super.func_201866_a(classification, entry);
    }

    @Override
    public void placeFeatures(GenerationStage.Decoration stage, MidnightChunkGenerator generator, WorldGenRegion world, long seed, SharedSeedRandom random, BlockPos origin) {
        this.func_203608_a(stage, (ChunkGenerator)generator, (IWorld)world, seed, random, origin);
    }

    @Override
    public void generateSurface(SharedSeedRandom random, IChunk chunk, int x, int z, int y, double depth, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        this.func_206854_a((Random)random, chunk, x, z, y, depth, defaultBlock, defaultFluid, seaLevel, seed);
    }

    @Override
    public Collection<ConfiguredCarver<?>> getCarversFor(GenerationStage.Carving stage) {
        return (Collection)this.field_201871_ag.get(stage);
    }

    @Override
    public List<Biome.SpawnListEntry> getSpawnsFor(EntityClassification classification) {
        return this.func_76747_a(classification);
    }

    public static class Properties
    extends Biome.Builder {
        private float ridgeWeight = 1.0f;
        private float densityScale = 1.0f;
        private int grassColor = 7760798;
        private int foliageColor = 9399740;
        private int skyColor = 1514290;
        private float fogStart = 20.0f;
        private float fogEnd = 140.0f;

        public Properties() {
            super.func_205415_a(Biome.RainType.NONE);
            super.func_205417_d(0.0f);
            super.func_205414_c(0.0f);
            super.func_205412_a(3546488);
            super.func_205413_b(329011);
        }

        public Properties ridgeWeight(float ridgeWeight) {
            this.ridgeWeight = ridgeWeight;
            return this;
        }

        public Properties densityScale(float densityScale) {
            this.densityScale = densityScale;
            return this;
        }

        public Properties grassColor(int grassColor) {
            this.grassColor = grassColor;
            return this;
        }

        public Properties foliageColor(int foliageColor) {
            this.foliageColor = foliageColor;
            return this;
        }

        public Properties skyColor(int skyColor) {
            this.skyColor = skyColor;
            return this;
        }

        public Properties fog(float start, float end) {
            this.fogStart = start;
            this.fogEnd = end;
            return this;
        }

        public <SC extends ISurfaceBuilderConfig> Properties surfaceBuilder(SurfaceBuilder<SC> surface, SC config) {
            super.func_222351_a(surface, config);
            return this;
        }

        public Properties surfaceBuilder(ConfiguredSurfaceBuilder<?> surface) {
            super.func_205416_a(surface);
            return this;
        }

        public Properties precipitation(Biome.RainType rainType) {
            super.func_205415_a(rainType);
            return this;
        }

        public Properties category(Biome.Category category) {
            super.func_205419_a(category);
            return this;
        }

        public Properties depth(float depth) {
            super.func_205421_a(depth);
            return this;
        }

        public Properties scale(float scale) {
            super.func_205420_b(scale);
            return this;
        }

        public Properties temperature(float temperature) {
            super.func_205414_c(temperature);
            return this;
        }

        public Properties downfall(float downfall) {
            super.func_205417_d(downfall);
            return this;
        }

        public Properties waterColor(int waterColor) {
            super.func_205412_a(waterColor);
            return this;
        }

        public Properties waterFogColor(int waterFogColor) {
            super.func_205413_b(waterFogColor);
            return this;
        }

        public Properties parent(@Nullable String parent) {
            super.func_205418_a(parent);
            return this;
        }
    }
}

