/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.google.common.collect.ImmutableList;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.ConfigurableBiome;
import com.mushroom.midnight.common.block.VioleafBlock;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightFeatures;
import com.mushroom.midnight.common.registry.MidnightPlacements;
import com.mushroom.midnight.common.registry.MidnightStructures;
import com.mushroom.midnight.common.world.feature.config.CrystalClusterConfig;
import com.mushroom.midnight.common.world.feature.config.MidnightOreConfig;
import com.mushroom.midnight.common.world.feature.config.UniformCompositionConfig;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class MidnightSurfaceConfigurator {
    public static final BlockClusterFeatureConfig GHOST_PLANT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.GHOST_PLANT.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig DRAGONNEST_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.DRAGON_NEST.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig CRYSTALFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.CRYSTAL_FLOWER.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig TALL_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.TALL_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig BIOLEAF_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)MidnightBlocks.VIOLEAF.func_176223_P().func_206870_a((IProperty)VioleafBlock.IS_GROWN, (Comparable)Boolean.valueOf(true))), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig RUNEBUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.RUNEBUSH.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig BOGWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.BOGWEED.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();

    public static void addStructureFeatures(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightStructures.MOLTEN_CRATER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightStructures.SHADOWROOT_GUARDTOWER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightStructures.WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addMoltenCrater(ConfigurableBiome biome) {
        biome.add(MidnightStructures.MOLTEN_CRATER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addGlobalOres(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.UNDERGROUND_ORES, MidnightFeatures.ORE.func_225566_b_((IFeatureConfig)new MidnightOreConfig(MidnightBlocks.DARK_PEARL_ORE.func_176223_P(), 14)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 56))));
        biome.add(GenerationStage.Decoration.UNDERGROUND_ORES, MidnightFeatures.ORE.func_225566_b_((IFeatureConfig)new MidnightOreConfig(MidnightBlocks.TENEBRUM_ORE.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 0, 0, 56))));
        biome.add(GenerationStage.Decoration.UNDERGROUND_ORES, MidnightFeatures.ORE.func_225566_b_((IFeatureConfig)new MidnightOreConfig(MidnightBlocks.NAGRILITE_ORE.func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 24))));
        biome.add(GenerationStage.Decoration.UNDERGROUND_ORES, MidnightFeatures.ORE.func_225566_b_((IFeatureConfig)new MidnightOreConfig(MidnightBlocks.EBONITE_ORE.func_176223_P(), 6)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 24))));
    }

    public static void addGlobalFeatures(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.LOCAL_MODIFICATIONS, MidnightFeatures.HEAP.func_225566_b_((IFeatureConfig)new UniformCompositionConfig(MidnightBlocks.ROCKSHROOM.func_176223_P())).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(100))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GHOST_PLANT_CONFIG).func_227228_a_(MidnightPlacements.COUNT_CHANCE_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(4, 0.3f))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DRAGONNEST_CONFIG).func_227228_a_(MidnightPlacements.DRAGON_NEST.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.UNSTABLE_BUSH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
    }

    public static void addLumen(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.LUMEN_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addNightshroomFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.NIGHTSHROOM_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addDewshroomFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.DEWSHROOM_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addViridshroomFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.VIRIDSHROOM_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addBogshroomFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.BOGSHROOM_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addMistshroomFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.MISTSHROOM_FLOWERS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
    }

    public static void addCrystalFlowers(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CRYSTALFLOWER_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(8))));
    }

    public static void addCrystalClusters(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightFeatures.CRYSTAL_CLUSTER.func_225566_b_((IFeatureConfig)new CrystalClusterConfig(MidnightBlocks.BLOOMCRYSTAL_ROCK.func_176223_P(), MidnightBlocks.BLOOMCRYSTAL.func_176223_P())).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightFeatures.CRYSTAL_SPIRE.func_225566_b_((IFeatureConfig)new CrystalClusterConfig(MidnightBlocks.BLOOMCRYSTAL_ROCK.func_176223_P(), MidnightBlocks.BLOOMCRYSTAL.func_176223_P())).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addGrasses(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GRASS_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TALL_GRASS_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
    }

    public static void addFingeredGrass(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.FINGERED_GRASS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addTrenchstoneBoulders(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.LOCAL_MODIFICATIONS, MidnightFeatures.TRENCHSTONE_BOULDER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(3))));
    }

    public static void addNightstoneSpikesAndBoulders(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(MidnightFeatures.NIGHTSTONE_BOULDER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), MidnightFeatures.SPIKE.func_225566_b_((IFeatureConfig)new UniformCompositionConfig(MidnightBlocks.NIGHTSTONE.func_176223_P())))).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
    }

    public static void addSparseShadowrootTrees(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(MidnightFeatures.SHADOWROOT_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), MidnightFeatures.DEAD_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e))).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(5))));
    }

    public static void addSparseSuavis(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.SUAVIS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
    }

    public static void addCommonSuavis(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.SUAVIS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(8))));
    }

    public static void addSparseDeadTrees(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.DEAD_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(6))));
    }

    public static void addVioleafs(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BIOLEAF_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addRunebushes(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RUNEBUSH_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(32))));
    }

    public static void addBogweed(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BOGWEED_CONFIG).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addFallenDeadLogs(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.FALLEN_DEAD_LOG.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addVigilantForestTrees(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(MidnightFeatures.SHADOWROOT_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), MidnightFeatures.DARK_WILLOW_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e))).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(8))));
    }

    public static void addBogTrees(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.DARK_WILLOW_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.SHADOWROOT_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addBogDeadTrees(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.BOG_DEAD_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(3))));
    }

    public static void addLargeBogshrooms(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202293_am.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(MidnightFeatures.LARGE_BOGSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), MidnightFeatures.SMALL_BOGSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e))).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(3))));
    }

    public static void addLargeFungis(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of((Object)MidnightFeatures.LARGE_NIGHTSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.LARGE_DEWSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.LARGE_VIRIDSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e)))).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of((Object)MidnightFeatures.MEDIUM_NIGHTSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.MEDIUM_DEWSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.MEDIUM_VIRIDSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e)))).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of((Object)MidnightFeatures.SMALL_NIGHTSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.SMALL_DEWSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Object)MidnightFeatures.SMALL_VIRIDSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e)))).func_227228_a_(MidnightPlacements.COUNT_SURFACE.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
    }

    public static void addBladeshrooms(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.BLADESHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addAlgaeAndMoss(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.DECEITFUL_ALGAE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.DECEITFUL_MOSS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_SURFACE_DOUBLE.func_227446_a_((IPlacementConfig)new FrequencyConfig(16))));
    }

    public static void addWell(ConfigurableBiome biome) {
        biome.add(MidnightStructures.WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addShadowRootGuardTower(ConfigurableBiome biome) {
        biome.add(MidnightStructures.SHADOWROOT_GUARDTOWER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addDeadViridShroomAndCache(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightFeatures.DEAD_VIRIDSHROOM_AND_CACHE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.CHANCE_SURFACE.func_227446_a_((IPlacementConfig)new ChanceConfig(45))));
    }

    public static void addStandardCreatureSpawns(ConfigurableBiome biome) {
        MidnightSurfaceConfigurator.addCreature(biome, MidnightEntities.NIGHTSTAG, 100, 1, 3);
    }

    public static void addStandardMonsterSpawns(ConfigurableBiome biome) {
        MidnightSurfaceConfigurator.addMonster(biome, MidnightEntities.RIFTER, 100, 1, 2);
        MidnightSurfaceConfigurator.addMonster(biome, EntityType.field_200803_q, 10, 4, 4);
    }

    public static void addRockySpawns(ConfigurableBiome biome) {
        MidnightSurfaceConfigurator.addMonster(biome, MidnightEntities.HUNTER, 5, 1, 2);
    }

    public static void addForestSpawns(ConfigurableBiome biome) {
        MidnightSurfaceConfigurator.addMonster(biome, MidnightEntities.SKULK, 100, 1, 2);
    }

    private static void addCreature(ConfigurableBiome biome, EntityType<?> type, int weight, int minGroupSize, int maxGroupSize) {
        biome.add(EntityClassification.CREATURE, new Biome.SpawnListEntry(type, weight, minGroupSize, maxGroupSize));
    }

    private static void addMonster(ConfigurableBiome biome, EntityType<?> type, int weight, int minGroupSize, int maxGroupSize) {
        biome.add(Midnight.MIDNIGHT_MOB, new Biome.SpawnListEntry(type, weight, minGroupSize, maxGroupSize));
    }
}

