/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.biome.ConfigurableBiome;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightCarvers;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightFeatures;
import com.mushroom.midnight.common.registry.MidnightPlacements;
import com.mushroom.midnight.common.world.feature.config.CrystalClusterConfig;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class MidnightCavernConfigurator {
    public static final BlockClusterFeatureConfig CRYSTALOTUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.CRYSTALOTUS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig TENDRILWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.TENDRILWEED.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig GLOB_FUNGI_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(MidnightBlocks.GLOB_FUNGUS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();

    public static void addCaves(ConfigurableBiome biome) {
        biome.add(GenerationStage.Carving.AIR, Biome.func_203606_a(MidnightCarvers.WIDE_CAVE, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    public static void addStandardFeatures(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CRYSTALOTUS_CONFIG).func_227228_a_(MidnightPlacements.CHANCE_UNDERGROUND_DOUBLE.func_227446_a_((IPlacementConfig)new ChanceConfig(20))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.STINGER_EGG.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_UNDERGROUND.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addTendrilweed(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TENDRILWEED_CONFIG).func_227228_a_(MidnightPlacements.COUNT_UNDERGROUND_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addRouxeClusters(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.SURFACE_STRUCTURES, MidnightFeatures.CRYSTAL_CLUSTER.func_225566_b_((IFeatureConfig)new CrystalClusterConfig(MidnightBlocks.ROUXE_ROCK.func_176223_P(), MidnightBlocks.ROUXE.func_176223_P())).func_227228_a_(MidnightPlacements.COUNT_UNDERGROUND.func_227446_a_((IPlacementConfig)new FrequencyConfig(5))));
    }

    public static void addBulbFungi(ConfigurableBiome biome) {
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GLOB_FUNGI_FLOWERS_CONFIG).func_227228_a_(MidnightPlacements.COUNT_UNDERGROUND_32.func_227446_a_((IPlacementConfig)new FrequencyConfig(7))));
        biome.add(GenerationStage.Decoration.VEGETAL_DECORATION, MidnightFeatures.LARGE_GLOB_FUNGUS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(MidnightPlacements.COUNT_UNDERGROUND.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
    }

    public static void addStandardSpawns(ConfigurableBiome biome) {
        MidnightCavernConfigurator.addMonster(biome, MidnightEntities.STINGER, 100, 2, 4);
        MidnightCavernConfigurator.addMonster(biome, EntityType.field_200803_q, 10, 4, 4);
    }

    private static void addCreature(ConfigurableBiome biome, EntityType<?> type, int weight, int minGroupSize, int maxGroupSize) {
        biome.add(EntityClassification.CREATURE, new Biome.SpawnListEntry(type, weight, minGroupSize, maxGroupSize));
    }

    private static void addMonster(ConfigurableBiome biome, EntityType<?> type, int weight, int minGroupSize, int maxGroupSize) {
        biome.add(Midnight.MIDNIGHT_MOB, new Biome.SpawnListEntry(type, weight, minGroupSize, maxGroupSize));
    }
}

