/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.gui.config;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mushroom.midnight.client.gui.config.ConfigInterfaceScreen;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class ConfigOptionList
extends AbstractOptionList<Row> {
    public ConfigOptionList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
        super(mc, width, height, top, bottom, itemHeight);
    }

    public int addEntry(Row entry) {
        return super.addEntry((AbstractList.AbstractListEntry)entry);
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    protected void renderHoleBackground(int top, int bottom, int topAlpha, int bottomAlpha) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(ConfigInterfaceScreen.MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)bottom, 0.0).func_225583_a_(0.0f, (float)bottom / 32.0f).func_225586_a_(64, 64, 64, bottomAlpha).func_181675_d();
        buff.func_225582_a_((double)(this.x0 + this.width), (double)bottom, 0.0).func_225583_a_((float)this.width / 32.0f, (float)bottom / 32.0f).func_225586_a_(64, 64, 64, bottomAlpha).func_181675_d();
        buff.func_225582_a_((double)(this.x0 + this.width), (double)top, 0.0).func_225583_a_((float)this.width / 32.0f, (float)top / 32.0f).func_225586_a_(64, 64, 64, topAlpha).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)top, 0.0).func_225583_a_(0.0f, (float)top / 32.0f).func_225586_a_(64, 64, 64, topAlpha).func_181675_d();
        tess.func_78381_a();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        int scrollbarLeft = this.getScrollbarPosition();
        int scrollbarRight = scrollbarLeft + 6;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(ConfigInterfaceScreen.MN_BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        tess.func_78381_a();
        int left = this.getRowLeft();
        int top = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(left, top, tess);
        }
        this.renderList(left, top, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)(this.y0 + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)(this.y0 + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tess.func_78381_a();
        buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buff.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buff.func_225582_a_((double)this.x1, (double)(this.y1 - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buff.func_225582_a_((double)this.x0, (double)(this.y1 - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tess.func_78381_a();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int scrollbarHeight = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            scrollbarHeight = MathHelper.func_76125_a((int)scrollbarHeight, (int)32, (int)(this.y1 - this.y0 - 8));
            int scrollbarY = (int)this.getScrollAmount() * (this.y1 - this.y0 - scrollbarHeight) / maxScroll + this.y0;
            if (scrollbarY < this.y0) {
                scrollbarY = this.y0;
            }
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)(scrollbarY + scrollbarHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)(scrollbarY + scrollbarHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarRight, (double)scrollbarY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)scrollbarY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_225582_a_((double)scrollbarLeft, (double)(scrollbarY + scrollbarHeight - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)(scrollbarRight - 1), (double)(scrollbarY + scrollbarHeight - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)(scrollbarRight - 1), (double)scrollbarY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buff.func_225582_a_((double)scrollbarLeft, (double)scrollbarY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        this.renderDecorations(mouseX, mouseY);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public static class HeaderRow
    extends Row {
        public HeaderRow(String label, ConfigInterfaceScreen screen) {
            super(label, null, screen);
        }

        protected void drawCenteredString(FontRenderer fontRenderer, String string, int x, int y, int color) {
            fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, color);
        }

        @Override
        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            this.renderTooltip(mouseX, mouseY, isMouseOver);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            this.drawCenteredString(font, TextFormatting.BOLD + this.label + TextFormatting.RESET, left + width / 2, top + height / 2 - 2, -1);
        }
    }

    public static class ButtonOnlyRow
    extends Row {
        public ButtonOnlyRow(Widget widget, ConfigInterfaceScreen screen) {
            super("", widget, screen);
        }

        @Override
        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            this.renderTooltip(mouseX, mouseY, isMouseOver);
            if (this.widget != null) {
                this.widget.x = left + width / 2 - this.widget.getWidth() / 2;
                this.widget.y = top + 2;
                this.widget.render(mouseX, mouseY, partialTicks);
            }
        }
    }

    public static class Row
    extends AbstractOptionList.Entry<Row> {
        protected final String label;
        protected final Widget widget;
        protected final ConfigInterfaceScreen screen;
        protected List<String> tooltip;
        private final List<IGuiEventListener> children;

        public Row(String label, Widget widget, ConfigInterfaceScreen screen) {
            this.label = label;
            this.widget = widget;
            this.screen = screen;
            this.children = widget != null ? Collections.singletonList(widget) : Collections.emptyList();
        }

        public Row withTooltip(String ... tooltip) {
            this.tooltip = Arrays.asList(tooltip);
            return this;
        }

        public List<? extends IGuiEventListener> children() {
            return this.children;
        }

        protected void renderTooltip(int mouseX, int mouseY, boolean mouseOver) {
            if (mouseOver) {
                this.screen.queueTooltip(this.tooltip);
            }
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            this.renderTooltip(mouseX, mouseY, isMouseOver);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            font.func_175063_a(this.label, (float)left + (float)(width / 2) - 155.0f, (float)top + (float)height / 2.0f - 2.0f, -1);
            if (this.widget != null) {
                this.widget.x = left + width / 2 + 5;
                this.widget.y = top + 2;
                this.widget.render(mouseX, mouseY, partialTicks);
            }
        }
    }
}

