/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.module;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.block.MachineFrameBlock;
import com.buuz135.industrial.block.core.DissolutionChamberBlock;
import com.buuz135.industrial.block.core.FluidExtractorBlock;
import com.buuz135.industrial.block.core.LatexProcessingUnitBlock;
import com.buuz135.industrial.block.core.tile.FluidExtractorTile;
import com.buuz135.industrial.item.BookManualItem;
import com.buuz135.industrial.item.FertilizerItem;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.item.ItemStraw;
import com.buuz135.industrial.item.RecipelessCustomItem;
import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.buuz135.industrial.item.bucket.MilkBucketItem;
import com.buuz135.industrial.module.IModule;
import com.buuz135.industrial.proxy.StrawRegistry;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.fluid.TitaniumFluidInstance;
import com.hrznstudio.titanium.module.Feature;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModuleCore
implements IModule {
    public static Rarity PITY_RARITY;
    public static Rarity SIMPLE_RARITY;
    public static Rarity ADVANCED_RARITY;
    public static Rarity SUPREME_RARITY;
    public static AdvancedTitaniumTab TAB_CORE;
    public static IFCustomItem TINY_DRY_RUBBER;
    public static IFCustomItem DRY_RUBBER;
    public static IFCustomItem PLASTIC;
    public static FertilizerItem FERTILIZER;
    public static IFCustomItem PINK_SLIME_ITEM;
    public static BookManualItem BOOK_MANUAL;
    public static IFCustomItem PINK_SLIME_INGOT;
    public static ItemStraw STRAW;
    public static MachineFrameBlock PITY;
    public static MachineFrameBlock SIMPLE;
    public static MachineFrameBlock ADVANCED;
    public static MachineFrameBlock SUPREME;
    public static FluidExtractorBlock FLUID_EXTRACTOR;
    public static LatexProcessingUnitBlock LATEX_PROCESSING;
    public static DissolutionChamberBlock DISSOLUTION_CHAMBER;
    public static RangeAddonItem[] RANGE_ADDONS;
    public static SpeedAddonItem SPEED_ADDON_1;
    public static SpeedAddonItem SPEED_ADDON_2;
    public static EfficiencyAddonItem EFFICIENCY_ADDON_1;
    public static EfficiencyAddonItem EFFICIENCY_ADDON_2;
    public static TitaniumFluidInstance LATEX;
    public static TitaniumFluidInstance MEAT;
    public static TitaniumFluidInstance SEWAGE;
    public static TitaniumFluidInstance ESSENCE;
    public static TitaniumFluidInstance SLUDGE;
    public static TitaniumFluidInstance PINK_SLIME;
    public static TitaniumFluidInstance MILK;
    public static TitaniumFluidInstance BIOFUEL;
    public static Item MILK_BUCKET;

    @Override
    public List<Feature.Builder> generateFeatures() {
        PITY_RARITY = Rarity.create((String)"pity", (TextFormatting)TextFormatting.GREEN);
        SIMPLE_RARITY = Rarity.create((String)"simple", (TextFormatting)TextFormatting.AQUA);
        ADVANCED_RARITY = Rarity.create((String)"advanced", (TextFormatting)TextFormatting.LIGHT_PURPLE);
        SUPREME_RARITY = Rarity.create((String)"supreme", (TextFormatting)TextFormatting.GOLD);
        PITY = new MachineFrameBlock("pity", PITY_RARITY, (ItemGroup)TAB_CORE);
        SIMPLE = new MachineFrameBlock("simple", SIMPLE_RARITY, (ItemGroup)TAB_CORE);
        ADVANCED = new MachineFrameBlock("advanced", ADVANCED_RARITY, (ItemGroup)TAB_CORE);
        SUPREME = new MachineFrameBlock("supreme", SUPREME_RARITY, (ItemGroup)TAB_CORE);
        ArrayList<Feature.Builder> features = new ArrayList<Feature.Builder>();
        features.add(Feature.builder((String)"plastic").content(Item.class, (IForgeRegistryEntry)TINY_DRY_RUBBER).content(Item.class, (IForgeRegistryEntry)DRY_RUBBER).content(Item.class, (IForgeRegistryEntry)PLASTIC).content(TitaniumFluidInstance.class, (IForgeRegistryEntry)LATEX).eventClient(() -> () -> EventManager.mod(TextureStitchEvent.Pre.class).process(this::textureStitch)));
        features.add(Feature.builder((String)"plastic_generation").content(Block.class, (IForgeRegistryEntry)FLUID_EXTRACTOR).content(Block.class, (IForgeRegistryEntry)LATEX_PROCESSING).event(EventManager.forge(TickEvent.WorldTickEvent.class).filter(worldTickEvent -> worldTickEvent.phase == TickEvent.Phase.END && worldTickEvent.type == TickEvent.Type.WORLD && worldTickEvent.world.func_82737_E() % 40L == 0L && FluidExtractorTile.EXTRACTION.containsKey(worldTickEvent.world.field_73011_w.func_186058_p())).process(worldTickEvent -> FluidExtractorTile.EXTRACTION.get(worldTickEvent.world.field_73011_w.func_186058_p()).values().forEach(blockPosFluidExtractionProgressHashMap -> blockPosFluidExtractionProgressHashMap.keySet().forEach(pos -> worldTickEvent.world.func_175715_c(((FluidExtractorTile.FluidExtractionProgress)blockPosFluidExtractionProgressHashMap.get(pos)).getBreakID(), pos, ((FluidExtractorTile.FluidExtractionProgress)blockPosFluidExtractionProgressHashMap.get(pos)).getProgress()))))));
        features.add(Feature.builder((String)"pink_slime").content(Item.class, (IForgeRegistryEntry)PINK_SLIME_ITEM).content(Item.class, (IForgeRegistryEntry)PINK_SLIME_INGOT).content(TitaniumFluidInstance.class, (IForgeRegistryEntry)PINK_SLIME));
        features.add(Feature.builder((String)"fertilizer").content(Item.class, (IForgeRegistryEntry)FERTILIZER));
        features.add(Feature.builder((String)"straw").event(EventManager.mod(RegistryEvent.Register.class).filter(register -> register.getGenericType().equals(StrawHandler.class)).process(StrawRegistry::register)).content(Item.class, (IForgeRegistryEntry)STRAW));
        features.add(Feature.builder((String)"machine_frames").content(Block.class, (IForgeRegistryEntry)PITY).content(Block.class, (IForgeRegistryEntry)SIMPLE).content(Block.class, (IForgeRegistryEntry)ADVANCED).content(Block.class, (IForgeRegistryEntry)SUPREME));
        features.add(Feature.builder((String)"tier_2_production").content(Block.class, (IForgeRegistryEntry)DISSOLUTION_CHAMBER));
        Feature.Builder builder = Feature.builder((String)"range_addons");
        for (int i = 0; i < RANGE_ADDONS.length; ++i) {
            ModuleCore.RANGE_ADDONS[i] = new RangeAddonItem(i, (ItemGroup)TAB_CORE);
            builder.content(Item.class, (IForgeRegistryEntry)RANGE_ADDONS[i]);
        }
        features.add(builder);
        features.add(Feature.builder((String)"speed_addons").content(Item.class, (IForgeRegistryEntry)SPEED_ADDON_1).content(Item.class, (IForgeRegistryEntry)SPEED_ADDON_2));
        features.add(Feature.builder((String)"efficiency_addons").content(Item.class, (IForgeRegistryEntry)EFFICIENCY_ADDON_1).content(Item.class, (IForgeRegistryEntry)EFFICIENCY_ADDON_2));
        features.add(Feature.builder((String)"meat").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)MEAT));
        features.add(Feature.builder((String)"sewage").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)SEWAGE));
        features.add(Feature.builder((String)"essence").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)ESSENCE));
        features.add(Feature.builder((String)"sludge").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)SLUDGE));
        features.add(Feature.builder((String)"biofuel").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)BIOFUEL));
        features.add(Feature.builder((String)"milk").content(TitaniumFluidInstance.class, (IForgeRegistryEntry)MILK));
        features.add(Feature.builder((String)"milk_bucket_replacement").description("If enabled the minecraft bucket item will be replaced with bucket that contains IF milk").content(Item.class, (IForgeRegistryEntry)MILK_BUCKET));
        MILK.setBucketFluid(MILK_BUCKET);
        TAB_CORE.addIconStack(new ItemStack((IItemProvider)PLASTIC));
        features.add(Feature.builder((String)"manual").content(Item.class, (IForgeRegistryEntry)BOOK_MANUAL));
        return features;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        event.addSprite(LATEX.getSourceFluid().getAttributes().getFlowingTexture());
        event.addSprite(LATEX.getSourceFluid().getAttributes().getStillTexture());
    }

    static {
        TAB_CORE = new AdvancedTitaniumTab("industrialforegoing_core", true);
        TINY_DRY_RUBBER = new RecipelessCustomItem("tinydryrubber", (ItemGroup)TAB_CORE);
        DRY_RUBBER = new RecipelessCustomItem("dryrubber", (ItemGroup)TAB_CORE);
        PLASTIC = new RecipelessCustomItem("plastic", (ItemGroup)TAB_CORE);
        FERTILIZER = new FertilizerItem((ItemGroup)TAB_CORE);
        PINK_SLIME_ITEM = new RecipelessCustomItem("pink_slime", (ItemGroup)TAB_CORE);
        BOOK_MANUAL = new BookManualItem((ItemGroup)TAB_CORE);
        PINK_SLIME_INGOT = new RecipelessCustomItem("pink_slime_ingot", (ItemGroup)TAB_CORE);
        STRAW = new ItemStraw((ItemGroup)TAB_CORE);
        FLUID_EXTRACTOR = new FluidExtractorBlock();
        LATEX_PROCESSING = new LatexProcessingUnitBlock();
        DISSOLUTION_CHAMBER = new DissolutionChamberBlock();
        RANGE_ADDONS = new RangeAddonItem[12];
        SPEED_ADDON_1 = new SpeedAddonItem(1, (ItemGroup)TAB_CORE);
        SPEED_ADDON_2 = new SpeedAddonItem(2, (ItemGroup)TAB_CORE);
        EFFICIENCY_ADDON_1 = new EfficiencyAddonItem(1, (ItemGroup)TAB_CORE);
        EFFICIENCY_ADDON_2 = new EfficiencyAddonItem(2, (ItemGroup)TAB_CORE);
        LATEX = new TitaniumFluidInstance("industrialforegoing", "latex", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/latex_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/latex_flow")), true, (ItemGroup)TAB_CORE);
        MEAT = new TitaniumFluidInstance("industrialforegoing", "meat", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/meat_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/meat_flow")), true, (ItemGroup)TAB_CORE);
        SEWAGE = new TitaniumFluidInstance("industrialforegoing", "sewage", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/sewage_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/sewage_flow")), true, (ItemGroup)TAB_CORE);
        ESSENCE = new TitaniumFluidInstance("industrialforegoing", "essence", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/essence_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/essence_flow")), true, (ItemGroup)TAB_CORE);
        SLUDGE = new TitaniumFluidInstance("industrialforegoing", "sludge", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/sludge_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/sludge_flow")), true, (ItemGroup)TAB_CORE);
        PINK_SLIME = new TitaniumFluidInstance("industrialforegoing", "pink_slime", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/pink_slime_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/pink_slime_flow")), true, (ItemGroup)TAB_CORE);
        MILK = new TitaniumFluidInstance("industrialforegoing", "milk", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/milk_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/milk_flow")), false, (ItemGroup)TAB_CORE);
        BIOFUEL = new TitaniumFluidInstance("industrialforegoing", "biofuel", FluidAttributes.builder((ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/biofuel_still"), (ResourceLocation)new ResourceLocation("industrialforegoing", "blocks/fluids/biofuel_flow")), true, (ItemGroup)TAB_CORE);
        MILK_BUCKET = (Item)new MilkBucketItem(() -> MILK.getSourceFluid(), new Item.Properties().func_200917_a(1).func_200919_a(Items.field_151133_ar).func_200916_a(ItemGroup.field_78026_f)).setRegistryName("minecraft", "milk_bucket");
    }
}

