/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public enum InfinityTier {
    POOR("poor", 0L, 0, TextFormatting.GRAY, 0x7C7C7A),
    COMMON("common", 4000000L, 1, TextFormatting.WHITE, 0xFFFFFF),
    UNCOMMON("uncommon", 16000000L, 2, TextFormatting.GREEN, 1894425),
    RARE("rare", 80000000L, 3, TextFormatting.BLUE, 34815),
    EPIC("epic", 480000000L, 4, TextFormatting.DARK_PURPLE, 14745855),
    LEGENDARY("legendary", 3360000000L, 5, TextFormatting.GOLD, 0xFFAA00),
    ARTIFACT("artifact", Long.MAX_VALUE, 6, TextFormatting.YELLOW, 0xFFF887);

    private final String name;
    private final TextFormatting color;
    private final int textureColor;
    private long powerNeeded;
    private int radius;

    private InfinityTier(String name, long powerNeeded, int radius, TextFormatting color, int textureColor) {
        this.name = name;
        this.powerNeeded = powerNeeded;
        this.radius = radius;
        this.color = color;
        this.textureColor = textureColor;
    }

    public static Pair<InfinityTier, InfinityTier> getTierBraquet(long power) {
        InfinityTier lastTier = POOR;
        for (InfinityTier infinityTier : InfinityTier.values()) {
            if (power >= lastTier.getPowerNeeded() && power < infinityTier.getPowerNeeded()) {
                return Pair.of((Object)((Object)lastTier), (Object)((Object)infinityTier));
            }
            lastTier = infinityTier;
        }
        return Pair.of((Object)((Object)ARTIFACT), (Object)((Object)ARTIFACT));
    }

    public String getLocalizedName() {
        return new TranslationTextComponent("text.industrialforegoing.tooltip.infinitydrill." + this.name, new Object[0]).func_150261_e();
    }

    public String getName() {
        return this.name;
    }

    public long getPowerNeeded() {
        return this.powerNeeded;
    }

    public void setPowerNeeded(long powerNeeded) {
        this.powerNeeded = powerNeeded;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public int getTextureColor() {
        return this.textureColor;
    }

    public InfinityTier getNext(InfinityTier maxTier) {
        InfinityTier lastTier = POOR;
        for (InfinityTier infinityTier : InfinityTier.values()) {
            if (infinityTier == POOR) continue;
            if (lastTier == maxTier) {
                return POOR;
            }
            if (this == lastTier) {
                return infinityTier;
            }
            lastTier = infinityTier;
        }
        return POOR;
    }

    public InfinityTier getPrev(InfinityTier maxTier) {
        InfinityTier lastTier = POOR;
        if (this == POOR) {
            return maxTier;
        }
        for (InfinityTier infinityTier : InfinityTier.values()) {
            if (infinityTier == POOR) continue;
            if (lastTier == maxTier) {
                return POOR;
            }
            if (this == infinityTier) {
                return lastTier;
            }
            lastTier = infinityTier;
        }
        return maxTier;
    }
}

