/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.conveyor;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiConveyor
extends ContainerScreen<ContainerConveyor> {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");
    private ConveyorUpgrade upgrade = this.getContainer().getConveyor().getUpgradeMap().get(this.getContainer().getFacing());
    private List<IGuiComponent> componentList = new ArrayList<IGuiComponent>();
    private int x;
    private int y;
    private List<IFilter.GhostSlot> ghostSlots = new ArrayList<IFilter.GhostSlot>();

    public GuiConveyor(ContainerConveyor inventorySlotsIn, PlayerInventory inventory, ITextComponent component) {
        super((Container)inventorySlotsIn, inventory, component);
    }

    protected void init() {
        super.init();
        this.componentList.clear();
        this.upgrade.addComponentsToGui(this.componentList);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!(iGuiComponent instanceof FilterGuiComponent)) continue;
            this.ghostSlots.addAll(Arrays.asList(((FilterGuiComponent)iGuiComponent).getFilter().getFilter()));
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BG_TEXTURE);
        this.x = (this.width - this.field_146999_f) / 2;
        this.y = (this.height - this.field_147000_g) / 2;
        this.blit(this.x, this.y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.upgrade != null) {
            String localized = new TranslationTextComponent(String.format("conveyor.upgrade.%s.%s", this.upgrade.getFactory().getRegistryName().func_110624_b(), this.upgrade.getFactory().getRegistryName().func_110623_a()), new Object[0]).func_150254_d();
            this.minecraft.field_71466_p.func_211126_b(localized, (float)(this.x + this.field_146999_f / 2 - this.minecraft.field_71466_p.func_78256_a(localized) / 2), (float)(this.y + 6), 0x404040);
        }
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiBackgroundLayer(this.x, this.y, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.x = (this.width - this.field_146999_f) / 2;
        this.y = (this.height - this.field_147000_g) / 2;
        for (IGuiComponent iGuiComponent : this.componentList) {
            iGuiComponent.drawGuiForegroundLayer(this.x, this.y, mouseX, mouseY);
        }
        this.func_191948_b(mouseX - this.x, mouseY - this.y);
        for (IGuiComponent iGuiComponent : this.componentList) {
            List<String> tooltips;
            if (!iGuiComponent.isInside(mouseX - this.x, mouseY - this.y) || (tooltips = iGuiComponent.getTooltip(this.x, this.y, mouseX, mouseY)) == null) continue;
            this.renderTooltip(tooltips, mouseX - this.x, mouseY - this.y);
        }
    }

    public ContainerConveyor getContainer() {
        return (ContainerConveyor)super.func_212873_a_();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean click = super.mouseClicked(mouseX, mouseY, mouseButton);
        for (IGuiComponent iGuiComponent : this.componentList) {
            if (!iGuiComponent.isInside(mouseX - (double)this.x, mouseY - (double)this.y) || !iGuiComponent.handleClick(this, this.x, this.y, mouseX, mouseY)) continue;
            return true;
        }
        return click;
    }

    public void sendMessage(int id, CompoundNBT compound) {
        IndustrialForegoing.NETWORK.get().sendToServer((Object)new ConveyorButtonInteractMessage(this.upgrade.getPos(), id, this.upgrade.getSide(), compound));
    }

    public List<IFilter.GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

