/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class InfinityEnergyScreenAddon
extends BasicScreenAddon {
    private final InfinityEnergyStorage handler;
    private final Pair<InfinityTier, InfinityTier> tier;
    private IAsset background;

    public InfinityEnergyScreenAddon(int posX, int posY, InfinityEnergyStorage handler) {
        super(posX, posY);
        this.handler = handler;
        this.tier = InfinityTier.getTierBraquet(handler.getLongEnergyStored());
    }

    public static IAsset drawBackground(Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY) {
        IAsset background = IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)AssetTypes.ENERGY_BACKGROUND);
        Point offset = background.getOffset();
        Rectangle area = background.getArea();
        AssetUtil.drawAsset((Screen)screen, (IAsset)background, (int)(guiX + handlerPosX + offset.x), (int)(guiY + handlerPosY + offset.y));
        return background;
    }

    public static void drawForeground(Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY, long stored, long capacity) {
        IAsset asset = IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)AssetTypes.ENERGY_BAR);
        Point offset = asset.getOffset();
        Rectangle area = asset.getArea();
        screen.getMinecraft().func_110434_K().func_110577_a(asset.getResourceLocation());
        int powerOffset = (int)(stored * (long)area.height / Math.max(capacity, 1L));
        screen.blit(handlerPosX + offset.x, handlerPosY + offset.y + area.height - powerOffset, area.x, area.y + (area.height - powerOffset), area.width, powerOffset);
    }

    public static List<String> getTooltip(long stored, long capacity) {
        return Arrays.asList(TextFormatting.GOLD + "Power:", new DecimalFormat().format(stored) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(capacity) + TextFormatting.DARK_AQUA + " FE");
    }

    public int getXSize() {
        return this.background != null ? this.background.getArea().width : 0;
    }

    public int getYSize() {
        return this.background != null ? this.background.getArea().height : 0;
    }

    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.background = InfinityEnergyScreenAddon.drawBackground(screen, provider, this.getPosX(), this.getPosY(), guiX, guiY);
    }

    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        InfinityEnergyScreenAddon.drawForeground(screen, provider, this.getPosX(), this.getPosY(), guiX, guiY, this.handler.getLongEnergyStored(), ((InfinityTier)((Object)this.tier.getRight())).getPowerNeeded());
    }

    public List<String> getTooltipLines() {
        return InfinityEnergyScreenAddon.getTooltip(this.handler.getLongEnergyStored(), ((InfinityTier)((Object)this.tier.getRight())).getPowerNeeded());
    }
}

