/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.world;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.config.Config;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.world.feature.OilLakesFeature;

public final class SMWorldFeatures {
    private SMWorldFeatures() {
    }

    public static void addFeaturesToBiomes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
            for (Ores ore : Ores.values()) {
                SMWorldFeatures.addOre(biome, ore);
            }
            SMWorldFeatures.addOilLakes(biome);
        }
    }

    private static void addOilLakes(Biome biome) {
        int config = (Integer)Config.worldGenOilLakeChance.get();
        if (config > 0) {
            int chance = biome == Biomes.field_76769_d ? 2 * config / 3 : config;
            biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, OilLakesFeature.INSTANCE.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(ModBlocks.OIL.asBlockState())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(chance))));
        }
    }

    private static void addOre(Biome biome, Ores ore) {
        ore.getConfig().ifPresent(config -> {
            if (config.isEnabled()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ore.asBlock().func_176223_P(), config.getVeinSize())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(config.getVeinCount(), config.getMinHeight(), 0, config.getMaxHeight()))));
            }
        });
    }
}

