/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.item;

import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.mechanisms.api.IMachineUpgrade;
import net.silentchaos512.mechanisms.init.Registration;
import net.silentchaos512.mechanisms.item.MachineUpgradeItem;

public enum MachineUpgrades implements IItemProvider,
IMachineUpgrade
{
    PROCESSING_SPEED(0.5f, 0.5f),
    OUTPUT_CHANCE(0.1f, 0.25f),
    ENERGY_CAPACITY(0.0f, 0.0f, false),
    ENERGY_EFFICIENCY(-0.15f, -0.15f),
    RANGE(2.0f, 0.15f, false);

    private ItemRegistryObject<MachineUpgradeItem> item;
    private final float upgradeValue;
    private final float energyUsage;
    private final boolean displayValueAsPercentage;

    private MachineUpgrades(float upgradeValue, float energyUsage) {
        this(upgradeValue, energyUsage, true);
    }

    private MachineUpgrades(float upgradeValue, float energyUsage, boolean displayValueAsPercentage) {
        this.upgradeValue = upgradeValue;
        this.energyUsage = energyUsage;
        this.displayValueAsPercentage = displayValueAsPercentage;
    }

    public static void register() {
        for (MachineUpgrades value : MachineUpgrades.values()) {
            value.item = new ItemRegistryObject(Registration.ITEMS.register(value.getName(), () -> new MachineUpgradeItem(value)));
        }
    }

    @Override
    public float getEnergyUsageMultiplier() {
        return this.energyUsage;
    }

    @Override
    public float getUpgradeValue() {
        return this.upgradeValue;
    }

    @Override
    public boolean displayValueAsPercentage() {
        return this.displayValueAsPercentage;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_upgrade";
    }

    public Item func_199767_j() {
        return (Item)this.item.get();
    }
}

