/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.function.Supplier;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModFluids;
import net.silentchaos512.mechanisms.init.Registration;
import net.silentchaos512.mechanisms.item.BatteryItem;
import net.silentchaos512.mechanisms.item.CanisterItem;
import net.silentchaos512.mechanisms.item.CraftingItems;
import net.silentchaos512.mechanisms.item.DebugItem;
import net.silentchaos512.mechanisms.item.EmptyCanisterItem;
import net.silentchaos512.mechanisms.item.HandPumpItem;
import net.silentchaos512.mechanisms.item.MachineUpgrades;
import net.silentchaos512.mechanisms.item.NoPlaceBucketItem;
import net.silentchaos512.mechanisms.item.WrenchItem;
import net.silentchaos512.mechanisms.util.color.ColorGetter;

public final class ModItems {
    public static final ItemRegistryObject<WrenchItem> WRENCH;
    public static final ItemRegistryObject<DebugItem> DEBUG_ITEM;
    public static final ItemRegistryObject<BatteryItem> BATTERY;
    public static final ItemRegistryObject<HandPumpItem> HAND_PUMP;
    public static final ItemRegistryObject<CanisterItem> CANISTER;
    public static final ItemRegistryObject<EmptyCanisterItem> EMPTY_CANISTER;
    public static final ItemRegistryObject<BucketItem> OIL_BUCKET;
    public static final ItemRegistryObject<BucketItem> DIESEL_BUCKET;
    public static final ItemRegistryObject<NoPlaceBucketItem> ETHANE_BUCKET;
    public static final ItemRegistryObject<NoPlaceBucketItem> POLYETHYLENE_BUCKET;

    private ModItems() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, tintIndex) -> {
            if (tintIndex == 1) {
                return ColorGetter.getColor(((CanisterItem)CANISTER.get()).getFluid(stack).getFluid());
            }
            return 0xFFFFFF;
        }, new IItemProvider[]{CANISTER});
    }

    private static BucketItem createBucketItem(Supplier<FlowingFluid> fluid) {
        return new BucketItem(fluid, new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP).func_200917_a(1).func_200919_a(Items.field_151133_ar));
    }

    private static NoPlaceBucketItem createNoPlaceBucketItem(Supplier<Fluid> fluid) {
        return new NoPlaceBucketItem(fluid, new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP).func_200917_a(1).func_200919_a(Items.field_151133_ar));
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    static {
        Metals.registerItems();
        CraftingItems.register();
        MachineUpgrades.register();
        WRENCH = ModItems.register("wrench", WrenchItem::new);
        DEBUG_ITEM = ModItems.register("debug_item", DebugItem::new);
        BATTERY = ModItems.register("battery", BatteryItem::new);
        HAND_PUMP = ModItems.register("hand_pump", HandPumpItem::new);
        CANISTER = ModItems.register("canister", () -> new CanisterItem(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP)));
        EMPTY_CANISTER = ModItems.register("empty_canister", () -> new EmptyCanisterItem(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP)));
        OIL_BUCKET = ModItems.register("oil_bucket", () -> ModItems.createBucketItem(() -> ModFluids.OIL));
        DIESEL_BUCKET = ModItems.register("diesel_bucket", () -> ModItems.createBucketItem(() -> ModFluids.DIESEL));
        ETHANE_BUCKET = ModItems.register("ethane_bucket", () -> ModItems.createNoPlaceBucketItem(() -> ModFluids.ETHANE));
        POLYETHYLENE_BUCKET = ModItems.register("polyethylene_bucket", () -> ModItems.createNoPlaceBucketItem(() -> ModFluids.POLYETHYLENE));
    }
}

