/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.silentchaos512.lib.data.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.data.ExtendedShapelessRecipeBuilder;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.data.recipes.AlloySmeltingRecipeBuilder;
import net.silentchaos512.mechanisms.data.recipes.CompressingRecipeBuilder;
import net.silentchaos512.mechanisms.data.recipes.CrushingRecipeBuilder;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.item.CraftingItems;
import net.silentchaos512.mechanisms.item.MachineUpgrades;

public class ModRecipesProvider
extends RecipeProvider {
    private static final int CRUSHING_CHUNKS_TIME = 300;
    private static final int CRUSHING_INGOT_TIME = 200;
    private static final int CRUSHING_ORE_TIME = 400;
    private static final float CRUSHING_CHUNKS_EXTRA_CHANCE = 0.1f;
    private static final float CRUSHING_ORE_STONE_CHANCE = 0.1f;

    public ModRecipesProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Silent's Mechanisms - Recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCrafting(consumer);
        this.registerSmelting(consumer);
        ModRecipesProvider.registerAlloySmelting(consumer);
        ModRecipesProvider.registerCompressingRecipes(consumer);
        ModRecipesProvider.registerCrushingRecipes(consumer);
    }

    private void registerCrafting(Consumer<IFinishedRecipe> consumer) {
        this.registerMetalCrafting(consumer);
        this.registerBlockCrafting(consumer);
        this.registerItemCrafting(consumer);
    }

    private void registerMetalCrafting(Consumer<IFinishedRecipe> consumer) {
        for (Metals metal : Metals.values()) {
            if (metal.getIngot().isPresent() && metal.getNuggetTag().isPresent()) {
                ExtendedShapedRecipeBuilder.vanillaBuilder((IItemProvider)((IItemProvider)metal.getIngot().get())).patternLine("###").patternLine("###").patternLine("###").key(Character.valueOf('#'), metal.getNuggetTag().get()).build(consumer, SilentMechanisms.getId("metals/" + metal.getName() + "_ingot_from_nugget"));
            }
            if (metal.getNugget().isPresent() && metal.getIngotTag().isPresent()) {
                ExtendedShapelessRecipeBuilder.vanillaBuilder((IItemProvider)((IItemProvider)metal.getNugget().get()), (int)9).addIngredient(metal.getIngotTag().get()).build(consumer, SilentMechanisms.getId("metals/" + metal.getName() + "_nugget"));
            }
            if (metal.getStorageBlock().isPresent() && metal.getIngotTag().isPresent()) {
                ExtendedShapedRecipeBuilder.vanillaBuilder((IItemProvider)((IItemProvider)metal.getStorageBlock().get())).patternLine("###").patternLine("###").patternLine("###").key(Character.valueOf('#'), metal.getIngotTag().get()).build(consumer, SilentMechanisms.getId("metals/" + metal.getName() + "_block"));
            }
            if (!metal.getIngot().isPresent() || !metal.getStorageBlockItemTag().isPresent()) continue;
            ExtendedShapelessRecipeBuilder.vanillaBuilder((IItemProvider)((IItemProvider)metal.getIngot().get()), (int)9).addIngredient(metal.getStorageBlockItemTag().get()).build(consumer, SilentMechanisms.getId("metals/" + metal.getName() + "_ingot_from_block"));
        }
    }

    private void registerBlockCrafting(Consumer<IFinishedRecipe> consumer) {
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.ACACIA_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196632_bu).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.BIRCH_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196627_bs).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.DARK_OAK_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196635_bv).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.JUNGLE_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196630_bt).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.OAK_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196622_bq).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModBlocks.SPRUCE_DRYING_RACK).patternLine("###").key(Character.valueOf('#'), (IItemProvider)Blocks.field_196624_br).build(consumer);
        ShapedRecipeBuilder.func_200468_a(ModBlocks.STONE_MACHINE_FRAME, (int)2).func_200472_a("/#/").func_200472_a("#s#").func_200472_a("/#/").func_200462_a(Character.valueOf('/'), (IItemProvider)Blocks.field_196579_bG).func_200469_a(Character.valueOf('#'), Tags.Items.GLASS).func_200469_a(Character.valueOf('s'), Tags.Items.INGOTS_IRON).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_196579_bG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a(ModBlocks.ALLOY_MACHINE_FRAME, (int)2).func_200472_a("/#/").func_200472_a("#s#").func_200472_a("/#/").func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200469_a(Character.valueOf('#'), Tags.Items.GLASS).func_200469_a(Character.valueOf('s'), ModTags.Items.STEELS).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REDSTONE_ALLOY.getIngotTag().get())).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.BASIC_ALLOY_SMELTER).func_200472_a("###").func_200472_a("/X/").func_200472_a("O/O").func_200469_a(Character.valueOf('#'), Metals.TIN.getIngotTag().get()).func_200469_a(Character.valueOf('/'), Metals.COPPER.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.STONE_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196584_bK).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.STONE_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.ALLOY_SMELTER).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Metals.BISMUTH_BRASS.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196584_bK).func_200462_a(Character.valueOf('H'), (IItemProvider)CraftingItems.HEATING_ELEMENT).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.ALLOY_SMELTER).func_200472_a("#C#").func_200472_a("/X/").func_200469_a(Character.valueOf('#'), Metals.BISMUTH_BRASS.getIngotTag().get()).func_200462_a(Character.valueOf('C'), ModBlocks.BASIC_ALLOY_SMELTER).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200467_a(consumer, SilentMechanisms.getId("alloy_smelter_from_basic"));
        ShapedRecipeBuilder.func_200470_a(ModBlocks.BASIC_CRUSHER).func_200472_a("###").func_200472_a("/X/").func_200472_a("O/O").func_200469_a(Character.valueOf('#'), Metals.BRONZE.getIngotTag().get()).func_200469_a(Character.valueOf('/'), Metals.ALUMINUM.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.STONE_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196579_bG).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.STONE_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.CRUSHER).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("ODO").func_200469_a(Character.valueOf('#'), Metals.BISMUTH_STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196579_bG).func_200469_a(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.CRUSHER).func_200472_a("#C#").func_200472_a("/X/").func_200472_a(" D ").func_200469_a(Character.valueOf('#'), Metals.BISMUTH_STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), ModBlocks.BASIC_CRUSHER).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200469_a(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200467_a(consumer, SilentMechanisms.getId("crusher_from_basic"));
        ShapedRecipeBuilder.func_200470_a(ModBlocks.COMPRESSOR).func_200472_a("#D#").func_200472_a("/X/").func_200472_a("ODC").func_200469_a(Character.valueOf('#'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196579_bG).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.ELECTRIC_FURNACE).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196579_bG).func_200462_a(Character.valueOf('H'), (IItemProvider)CraftingItems.HEATING_ELEMENT).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.REFINERY).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Metals.ALUMINUM_STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200462_a(Character.valueOf('/'), ModItems.EMPTY_CANISTER).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200469_a(Character.valueOf('O'), Metals.ELECTRUM.getIngotTag().get()).func_200462_a(Character.valueOf('H'), (IItemProvider)CraftingItems.HEATING_ELEMENT).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.MIXER).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Metals.BISMUTH_STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200462_a(Character.valueOf('/'), ModItems.EMPTY_CANISTER).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200469_a(Character.valueOf('O'), Metals.BRASS.getIngotTag().get()).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221602_aD).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.SOLIDIFIER).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Metals.STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200462_a(Character.valueOf('/'), ModItems.EMPTY_CANISTER).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200469_a(Character.valueOf('O'), Metals.SILVER.getIngotTag().get()).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221790_de).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.PUMP).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("OHO").func_200469_a(Character.valueOf('#'), Metals.ALUMINUM.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200469_a(Character.valueOf('/'), Metals.INVAR.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Items.field_151133_ar).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_221602_aD).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.COAL_GENERATOR).func_200472_a("###").func_200472_a("/X/").func_200472_a("OAO").func_200469_a(Character.valueOf('#'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('/'), Metals.COPPER.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.STONE_MACHINE_FRAME).func_200469_a(Character.valueOf('O'), Tags.Items.COBBLESTONE).func_200469_a(Character.valueOf('A'), Metals.REFINED_IRON.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.STONE_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.LAVA_GENERATOR).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("#O#").func_200469_a(Character.valueOf('#'), Metals.INVAR.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_196579_bG).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.DIESEL_GENERATOR).func_200472_a("#C#").func_200472_a("/X/").func_200472_a("#B#").func_200469_a(Character.valueOf('#'), Metals.STEEL.getIngotTag().get()).func_200462_a(Character.valueOf('C'), (IItemProvider)CraftingItems.CIRCUIT_BOARD).func_200471_a(Character.valueOf('/'), Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(Metals.PLATINUM.getNuggetTag().get()), new Ingredient.TagList(Metals.SILVER.getIngotTag().get())))).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151133_ar).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModBlocks.BATTERY_BOX).func_200472_a("#B#").func_200472_a("/X/").func_200472_a("L/L").func_200469_a(Character.valueOf('#'), Metals.ALUMINUM.getIngotTag().get()).func_200462_a(Character.valueOf('B'), ModItems.BATTERY).func_200462_a(Character.valueOf('/'), ModBlocks.WIRE).func_200462_a(Character.valueOf('X'), ModBlocks.ALLOY_MACHINE_FRAME).func_200469_a(Character.valueOf('L'), Metals.LEAD.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)ModBlocks.ALLOY_MACHINE_FRAME)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a(ModBlocks.WIRE, (int)12).func_200472_a("///").func_200472_a("###").func_200471_a(Character.valueOf('/'), Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(Metals.COPPER.getIngotTag().get()), new Ingredient.TagList(Metals.REFINED_IRON.getIngotTag().get())))).func_200469_a(Character.valueOf('#'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REDSTONE_ALLOY.getIngotTag().get())).func_200464_a(consumer);
    }

    private void registerItemCrafting(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.CIRCUIT_BOARD, (int)3).func_200472_a("/G/").func_200472_a("###").func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200469_a(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('#'), Metals.COPPER.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REDSTONE_ALLOY.getIngotTag().get())).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.HEATING_ELEMENT, (int)2).func_200472_a("##").func_200472_a("##").func_200472_a("/ ").func_200469_a(Character.valueOf('#'), Metals.COPPER.getIngotTag().get()).func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REDSTONE_ALLOY.getIngotTag().get())).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)CraftingItems.PLASTIC_SHEET).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.PLASTIC_PELLETS).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.PLASTIC_PELLETS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)CraftingItems.UPGRADE_CASE, (int)2).func_200472_a("###").func_200472_a("###").func_200472_a("///").func_200462_a(Character.valueOf('#'), (IItemProvider)CraftingItems.PLASTIC_SHEET).func_200469_a(Character.valueOf('/'), Tags.Items.NUGGETS_GOLD).func_200465_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.PLASTIC_SHEET)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)MachineUpgrades.PROCESSING_SPEED).func_200487_b((IItemProvider)CraftingItems.UPGRADE_CASE).func_203221_a(Tags.Items.STORAGE_BLOCKS_REDSTONE).func_203221_a(Metals.SILVER.getIngotTag().get()).func_203221_a(Metals.SILVER.getIngotTag().get()).func_200483_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.UPGRADE_CASE)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)MachineUpgrades.OUTPUT_CHANCE).func_200487_b((IItemProvider)CraftingItems.UPGRADE_CASE).func_203221_a(Tags.Items.STORAGE_BLOCKS_LAPIS).func_203221_a(Metals.PLATINUM.getIngotTag().get()).func_203221_a(Metals.PLATINUM.getIngotTag().get()).func_200483_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.UPGRADE_CASE)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)MachineUpgrades.ENERGY_EFFICIENCY).func_200487_b((IItemProvider)CraftingItems.UPGRADE_CASE).func_200487_b((IItemProvider)Items.field_221695_cJ).func_203221_a(Metals.ELECTRUM.getIngotTag().get()).func_203221_a(Metals.ELECTRUM.getIngotTag().get()).func_200483_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.UPGRADE_CASE)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)MachineUpgrades.RANGE).func_200487_b((IItemProvider)CraftingItems.UPGRADE_CASE).func_203221_a(Tags.Items.ENDER_PEARLS).func_203221_a(Metals.INVAR.getIngotTag().get()).func_203221_a(Metals.INVAR.getIngotTag().get()).func_200483_a("has_item", (ICriterionInstance)this.func_200403_a(CraftingItems.UPGRADE_CASE)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModItems.WRENCH).func_200472_a("/ /").func_200472_a(" # ").func_200472_a(" / ").func_200469_a(Character.valueOf('/'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('#'), Metals.REFINED_IRON.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REFINED_IRON.getIngotTag().get())).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a(ModItems.BATTERY).func_200472_a(" / ").func_200472_a("#X#").func_200472_a("LXL").func_200469_a(Character.valueOf('/'), Metals.REDSTONE_ALLOY.getIngotTag().get()).func_200469_a(Character.valueOf('#'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('L'), Metals.LEAD.getIngotTag().get()).func_200465_a("has_item", (ICriterionInstance)this.func_200409_a(Metals.REDSTONE_ALLOY.getIngotTag().get())).func_200464_a(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModItems.HAND_PUMP).patternLine("/C#").patternLine(" B#").key(Character.valueOf('/'), Metals.ALUMINUM.getIngotTag().get()).key(Character.valueOf('C'), ModItems.EMPTY_CANISTER).key(Character.valueOf('#'), (IItemProvider)CraftingItems.PLASTIC_SHEET).key(Character.valueOf('B'), ModItems.BATTERY).build(consumer);
        ExtendedShapedRecipeBuilder.vanillaBuilder(ModItems.EMPTY_CANISTER, (int)8).patternLine(" # ").patternLine("# #").patternLine(" # ").key(Character.valueOf('#'), Metals.ALUMINUM.getIngotTag().get()).build(consumer);
        ExtendedShapelessRecipeBuilder.vanillaBuilder(ModItems.EMPTY_CANISTER).addIngredient(ModItems.CANISTER).build(consumer, SilentMechanisms.getId("canister_clear"));
    }

    private void registerSmelting(Consumer<IFinishedRecipe> consumer) {
        for (Metals metal : Metals.values()) {
            if (metal.getIngot().isPresent() && (metal.getChunksTag().isPresent() || metal.getDustTag().isPresent())) {
                this.smeltingAndBlasting(consumer, metal.getName() + "_ingot", metal.getSmeltables(false), (IItemProvider)metal.getIngot().get());
            }
            if (!metal.getIngot().isPresent() || !metal.getOreItemTag().isPresent()) continue;
            this.smeltingAndBlasting(consumer, metal.getName() + "_ingot_from_ore", Ingredient.func_199805_a(metal.getOreItemTag().get()), (IItemProvider)metal.getIngot().get());
        }
        this.smeltingAndBlasting(consumer, "iron_ingot", Metals.IRON.getSmeltables(false), (IItemProvider)Items.field_151042_j);
        this.smeltingAndBlasting(consumer, "gold_ingot", Metals.GOLD.getSmeltables(false), (IItemProvider)Items.field_151043_k);
        assert (Metals.REFINED_IRON.getIngot().isPresent());
        this.smeltingAndBlasting(consumer, "refined_iron_ingot", Ingredient.func_199805_a((Tag)Tags.Items.INGOTS_IRON), (IItemProvider)Metals.REFINED_IRON.getIngot().get());
    }

    private void smeltingAndBlasting(Consumer<IFinishedRecipe> consumer, String name, Ingredient ingredient, IItemProvider result) {
        CookingRecipeBuilder.func_218629_c((Ingredient)ingredient, (IItemProvider)result, (float)1.0f, (int)200).func_218628_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_150460_al)).func_218635_a(consumer, SilentMechanisms.getId("smelting/" + name));
        CookingRecipeBuilder.func_218633_b((Ingredient)ingredient, (IItemProvider)result, (float)1.0f, (int)100).func_218628_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_150460_al)).func_218635_a(consumer, SilentMechanisms.getId("blasting/" + name));
    }

    private static void registerAlloySmelting(Consumer<IFinishedRecipe> consumer) {
        AlloySmeltingRecipeBuilder.builder(Metals.ALUMINUM_STEEL, 4, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 3).ingredient(Metals.ALUMINUM, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BISMUTH_BRASS, 4, 400).ingredient(Metals.COPPER, 2).ingredient(Metals.ZINC, 1).ingredient(Metals.BISMUTH, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BISMUTH_STEEL, 4, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 3).ingredient(Metals.BISMUTH, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BRASS, 4, 400).ingredient(Metals.COPPER, 3).ingredient(Metals.ZINC, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BRONZE, 4, 400).ingredient(Metals.COPPER, 3).ingredient(Metals.TIN, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.ELECTRUM, 2, 400).ingredient(Metals.GOLD, 1).ingredient(Metals.SILVER, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.ENDERIUM, 4, 500).ingredient(Metals.LEAD, 3).ingredient(Metals.PLATINUM, 1).ingredient((Tag<Item>)Tags.Items.ENDER_PEARLS, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.INVAR, 3, 400).ingredient(Metals.IRON, 2).ingredient(Metals.NICKEL, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.LUMIUM, 4, 500).ingredient(Metals.TIN, 3).ingredient(Metals.SILVER, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.REDSTONE_ALLOY, 2, 200).ingredient(Metals.IRON, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.SIGNALUM, 4, 500).ingredient(Metals.COPPER, 3).ingredient(Metals.SILVER, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 10).build(consumer);
        AlloySmeltingRecipeBuilder.builder(CraftingItems.SOLDER, 12, 200).ingredient(Metals.TIN, 1).ingredient(Metals.LEAD, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.STEEL, 2, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 2).build(consumer);
    }

    private static void registerCompressingRecipes(Consumer<IFinishedRecipe> consumer) {
        CompressingRecipeBuilder.builder((IItemProvider)Items.field_151065_br, 4, (IItemProvider)Items.field_151072_bj, 1, 400).build(consumer);
        assert (Metals.COMPRESSED_IRON.getIngot().isPresent());
        CompressingRecipeBuilder.builder((Tag<Item>)Tags.Items.INGOTS_IRON, 1, (IItemProvider)Metals.COMPRESSED_IRON.getIngot().get(), 1, 400).build(consumer);
        CompressingRecipeBuilder.builder((Tag<Item>)Tags.Items.STORAGE_BLOCKS_COAL, 16, (IItemProvider)Items.field_151045_i, 1, 800).build(consumer);
    }

    private static void registerCrushingRecipes(Consumer<IFinishedRecipe> consumer) {
        for (Metals metal : Metals.values()) {
            if (metal.getOreItemTag().isPresent() && metal.getChunks().isPresent()) {
                ModRecipesProvider.crushingOre(metal.getOreItemTag().get(), (IItemProvider)metal.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
            }
            if (metal.getChunksTag().isPresent() && metal.getDust().isPresent()) {
                ModRecipesProvider.crushingChunks(metal.getChunksTag().get(), (IItemProvider)metal.getDust().get()).build(consumer);
            }
            if (!metal.getIngotTag().isPresent() || !metal.getDust().isPresent()) continue;
            ModRecipesProvider.crushingIngot(metal.getIngotTag().get(), (IItemProvider)metal.getDust().get()).build(consumer, SilentMechanisms.getId("crushing/" + metal.getName() + "_dust_from_ingot"));
        }
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_COAL, 400).result((IItemProvider)Items.field_151044_h, 2).result((IItemProvider)Items.field_221585_m, 1, 0.1f).result((IItemProvider)Items.field_151045_i, 1, 0.001f).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_LAPIS, 400).result((IItemProvider)Items.field_196128_bn, 12).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_REDSTONE, 400).result((IItemProvider)Items.field_151137_ax, 6).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_QUARTZ, (IItemProvider)Items.field_151128_bU).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_DIAMOND, (IItemProvider)Items.field_151045_i).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_EMERALD, (IItemProvider)Items.field_151166_bC).build(consumer);
        ModRecipesProvider.crushingOre((Tag<Item>)Tags.Items.ORES_GOLD, (IItemProvider)Metals.GOLD.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
        ModRecipesProvider.crushingOre((Tag<Item>)Tags.Items.ORES_IRON, (IItemProvider)Metals.IRON.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.RODS_BLAZE, 200).result((IItemProvider)Items.field_151065_br, 4).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150435_aG, 100).result((IItemProvider)Items.field_151119_aD, 4).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Items.field_151044_h, 200).result(CraftingItems.COAL_DUST, 1).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150426_aN, 100).result((IItemProvider)Items.field_151114_aO, 4).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.COBBLESTONE, 200).result((IItemProvider)Blocks.field_150351_n, 1).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)ItemTags.field_200038_h, 200).result((IItemProvider)Items.field_151121_aF, 1, 0.75f).result((IItemProvider)Items.field_151121_aF, 1, 0.25f).result((IItemProvider)Items.field_151055_y, 1, 0.25f).result((IItemProvider)Items.field_151055_y, 1, 0.25f).build(consumer);
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150371_ca, Blocks.field_196770_fj, Blocks.field_196772_fk, Blocks.field_196581_bI}), 200).result((IItemProvider)Items.field_151128_bU, 4).build(consumer, SilentMechanisms.getId("crushing/quartz_from_blocks"));
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_180395_cM, Blocks.field_196798_hA}), 200).result((IItemProvider)Blocks.field_196611_F, 4).build(consumer, SilentMechanisms.getId("crushing/red_sand_from_sandstone"));
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150322_A, Blocks.field_196583_aj}), 200).result((IItemProvider)Blocks.field_150354_m, 4).build(consumer, SilentMechanisms.getId("crushing/sand_from_sandstone"));
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150351_n, 200).result((IItemProvider)Blocks.field_150354_m, 1).result((IItemProvider)Items.field_151145_ak, 1, 0.1f).build(consumer);
    }

    public static CrushingRecipeBuilder crushingChunks(Tag<Item> chunks, IItemProvider dust) {
        return CrushingRecipeBuilder.crushingChunks(chunks, dust, 300, 0.1f);
    }

    public static CrushingRecipeBuilder crushingIngot(Tag<Item> ingot, IItemProvider dust) {
        return CrushingRecipeBuilder.crushingIngot(ingot, dust, 200);
    }

    public static CrushingRecipeBuilder crushingOre(Tag<Item> ore, IItemProvider chunks, @Nullable IItemProvider extra) {
        return CrushingRecipeBuilder.crushingOre(ore, chunks, 400, extra, 0.1f);
    }

    public static CrushingRecipeBuilder crushingOreBonus(Tag<Item> ore, IItemProvider item) {
        return CrushingRecipeBuilder.builder(ore, 400).result(item, 2).result(item, 1, 0.1f).result((IItemProvider)Blocks.field_150347_e, 1, 0.1f);
    }
}

