/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.mechanisms.crafting.recipe.CompressingRecipe;

public class CompressingRecipeBuilder {
    private final Ingredient ingredient;
    private final int ingredientCount;
    private final ItemStack result;
    private final int processTime;

    private CompressingRecipeBuilder(Ingredient ingredient, int ingredientCount, IItemProvider result, int resultCount, int processTime) {
        this.ingredient = ingredient;
        this.ingredientCount = ingredientCount;
        this.result = new ItemStack(result, resultCount);
        this.processTime = processTime;
    }

    public static CompressingRecipeBuilder builder(Ingredient ingredient, int ingredientCount, IItemProvider result, int resultCount, int processTime) {
        return new CompressingRecipeBuilder(ingredient, ingredientCount, result, resultCount, processTime);
    }

    public static CompressingRecipeBuilder builder(Tag<Item> ingredient, int ingredientCount, IItemProvider result, int resultCount, int processTime) {
        return CompressingRecipeBuilder.builder(Ingredient.func_199805_a(ingredient), ingredientCount, result, resultCount, processTime);
    }

    public static CompressingRecipeBuilder builder(IItemProvider ingredient, int ingredientCount, IItemProvider result, int resultCount, int processTime) {
        return CompressingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), ingredientCount, result, resultCount, processTime);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation resultId = NameUtils.fromItem((ItemStack)this.result);
        ResourceLocation id = new ResourceLocation("minecraft".equals(resultId.func_110624_b()) ? "silents_mechanisms" : resultId.func_110624_b(), "compressing/" + resultId.func_110623_a());
        this.build(consumer, id);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final CompressingRecipeBuilder builder;

        public Result(ResourceLocation id, CompressingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("process_time", (Number)this.builder.processTime);
            JsonObject ingredient = new JsonObject();
            ingredient.add("value", this.builder.ingredient.func_200304_c());
            ingredient.addProperty("count", (Number)this.builder.ingredientCount);
            json.add("ingredient", (JsonElement)ingredient);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.fromItem((ItemStack)this.builder.result).toString());
            if (this.builder.result.func_190916_E() > 1) {
                result.addProperty("count", (Number)this.builder.result.func_190916_E());
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return CompressingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

