/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.init.Registration;

public class ModBlockTagsProvider
extends BlockTagsProvider {
    public ModBlockTagsProvider(DataGenerator gen) {
        super(gen);
    }

    protected void func_200432_c() {
        this.func_200426_a(ModTags.Blocks.DRYING_RACKS).func_200573_a((Object[])Registration.getBlocks(DryingRackBlock.class).toArray(new Block[0]));
        for (Metals metal : Metals.values()) {
            metal.getOreTag().ifPresent(tag -> this.func_200426_a((Tag)tag).func_200048_a((Object)metal.getOre().get()));
            metal.getStorageBlockTag().ifPresent(tag -> this.func_200426_a((Tag)tag).func_200048_a((Object)metal.getStorageBlock().get()));
        }
        this.groupBuilder((Tag<Block>)Tags.Blocks.ORES, Metals::getOreTag);
        this.groupBuilder((Tag<Block>)Tags.Blocks.STORAGE_BLOCKS, Metals::getStorageBlockTag);
    }

    private void groupBuilder(Tag<Block> tag, Function<Metals, Optional<Tag<Block>>> tagGetter) {
        Tag.Builder builder = this.func_200426_a(tag);
        for (Metals metal : Metals.values()) {
            tagGetter.apply(metal).ifPresent(arg_0 -> ((Tag.Builder)builder).func_200574_a(arg_0));
        }
    }

    private void builder(ResourceLocation id, IBlockProvider ... items) {
        this.func_200426_a(ModBlockTagsProvider.blockTag(id)).func_200573_a((Object[])Arrays.stream(items).map(IBlockProvider::asBlock).toArray(Block[]::new));
    }

    private void builder(ResourceLocation id, Block ... blocks) {
        this.func_200426_a(ModBlockTagsProvider.blockTag(id)).func_200573_a((Object[])blocks);
    }

    private static Tag<Block> blockTag(ResourceLocation id) {
        return new BlockTags.Wrapper(id);
    }

    private static Tag<Item> itemTag(ResourceLocation id) {
        return new ItemTags.Wrapper(id);
    }

    private static ResourceLocation modId(String path) {
        return SilentMechanisms.getId(path);
    }

    private static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    public String func_200397_b() {
        return "Silent's Mechanisms - Block Tags";
    }
}

