/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator.lava;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.block.generator.AbstractFluidFuelGeneratorTileEntity;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorContainer;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.TextUtil;

public class LavaGeneratorTileEntity
extends AbstractFluidFuelGeneratorTileEntity {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_SEND = 500;
    public static final int ENERGY_CREATED_PER_TICK = 100;
    public static final int TICKS_PER_MILLIBUCKET = 5;
    static final int TANK_CAPACITY = 4000;

    public LavaGeneratorTileEntity() {
        super(ModTileEntities.lavaGenerator, 2, 50000, 0, 500, new FluidTank(4000, s -> s.getFluid().func_207185_a(FluidTags.field_206960_b)));
    }

    public IFluidHandler getTank() {
        return this.tank;
    }

    @Override
    protected boolean hasFuel() {
        return this.tank.getFluidAmount() > 0;
    }

    @Override
    protected int getFuelBurnTime(FluidStack fluid) {
        return 5 * fluid.getAmount();
    }

    @Override
    protected int getEnergyCreatedPerTick() {
        return 100;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && IFluidContainer.getBucketOrContainerFluid(stack).getFluid().func_207185_a(FluidTags.field_206960_b);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "lava_generator", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new LavaGeneratorContainer(id, playerInventory, this, this.fields);
    }
}

