/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.compressor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.block.compressor.CompressorContainer;
import net.silentchaos512.mechanisms.crafting.recipe.CompressingRecipe;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class CompressorTileEntity
extends AbstractMachineTileEntity<CompressingRecipe> {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_RECEIVE = 500;
    public static final int ENERGY_USED_PER_TICK = 30;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = new int[]{1};
    private static final int[] SLOTS_ALL = new int[]{0, 1};

    public CompressorTileEntity() {
        super(ModTileEntities.compressor, 2, MachineTier.STANDARD);
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 30;
    }

    @Override
    protected int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    @Nullable
    protected CompressingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(CompressingRecipe.RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(CompressingRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<ItemStack> getProcessResults(CompressingRecipe recipe) {
        return Collections.singleton(recipe.func_77572_b(this));
    }

    @Override
    protected void consumeIngredients(CompressingRecipe recipe) {
        this.func_70298_a(0, recipe.getIngredientCount());
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "compressor", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new CompressorContainer(id, playerInventory, this, this.fields);
    }

    List<String> getDebugText() {
        return ImmutableList.of((Object)("progress = " + this.fields.func_221476_a(0)), (Object)("processTime = " + this.fields.func_221476_a(1)), (Object)("energy = " + this.fields.func_221476_a(2) + " FE / " + this.getMaxEnergyStored() + " FE"), (Object)"ENERGY_USED_PER_TICK = 30", (Object)"MAX_RECEIVE = 500");
    }
}

