/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.integration.jei.extension;

import info.u_team.u_team_core.api.dye.IDyeableItem;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.integration.jei.extension.CraftingGridHelper;
import info.u_team.useful_backpacks.recipe.BackpackCraftingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Size2i;

public class BackpackCraftingRecipeCategoryExtension
implements ICustomCraftingCategoryExtension {
    private final BackpackCraftingRecipe recipe;
    private final ICraftingGridHelper craftingGridHelper;

    public BackpackCraftingRecipeCategoryExtension(BackpackCraftingRecipe recipe) {
        this.recipe = recipe;
        this.craftingGridHelper = new CraftingGridHelper(1);
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.func_199560_c();
    }

    public Size2i getSize() {
        return new Size2i(this.recipe.getRecipeWidth(), this.recipe.getRecipeHeight());
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients((List)this.recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        ArrayList outputs;
        ArrayList<List<Object>> inputs;
        IGuiItemStackGroup guiItemStacks;
        block5: {
            block7: {
                IFocus.Mode mode;
                Item focusItem;
                ItemStack focusStack;
                block6: {
                    int index;
                    guiItemStacks = recipeLayout.getItemStacks();
                    List providedInputs = ingredients.getInputs(VanillaTypes.ITEM);
                    List providedOutputs = ingredients.getOutputs(VanillaTypes.ITEM);
                    inputs = new ArrayList<List<Object>>();
                    outputs = new ArrayList();
                    for (index = 0; index < providedInputs.size(); ++index) {
                        inputs.add(index, new ArrayList((Collection)providedInputs.get(index)));
                    }
                    for (index = 0; index < providedOutputs.size(); ++index) {
                        outputs.add(index, new ArrayList((Collection)providedOutputs.get(index)));
                    }
                    if (recipeLayout.getFocus() == null || !(recipeLayout.getFocus().getValue() instanceof ItemStack) || !(((ItemStack)((List)outputs.get(0)).get(0)).func_77973_b() instanceof IDyeableItem)) break block5;
                    focusStack = (ItemStack)recipeLayout.getFocus().getValue();
                    focusItem = focusStack.func_77973_b();
                    mode = recipeLayout.getFocus().getMode();
                    if (mode != IFocus.Mode.INPUT || !ItemTags.field_199904_a.func_199685_a_((Object)focusItem)) break block6;
                    DyeColor color = ColorUtil.getColorFromWool((Block)Block.func_149634_a((Item)focusItem));
                    if (color != null && color != DyeColor.WHITE) {
                        ((List)outputs.get(0)).set(0, IDyeableItem.colorStack((ItemStack)((ItemStack)((List)outputs.get(0)).get(0)), Arrays.asList(color)));
                    }
                    break block5;
                }
                if (mode != IFocus.Mode.OUTPUT || !(focusItem instanceof IDyeableItem)) break block5;
                IDyeableItem dyeableItem = (IDyeableItem)focusItem;
                if (!dyeableItem.hasColor(focusStack)) break block7;
                int focusColor = dyeableItem.getColor(focusStack);
                Optional<DyeColor> colorMatch = Stream.of(DyeColor.values()).filter(dyeColor -> dyeColor.getColorValue() == focusColor).findAny();
                if (!colorMatch.isPresent()) break block5;
                DyeColor color = colorMatch.get();
                Block wool = ColorUtil.getWoolFromColor((DyeColor)color);
                for (int index = 0; index < inputs.size(); ++index) {
                    List list = (List)inputs.get(index);
                    if (!list.stream().allMatch(stack -> ItemTags.field_199904_a.func_199685_a_((Object)stack.func_77973_b()))) continue;
                    inputs.set(index, Arrays.asList(new ItemStack((IItemProvider)wool)));
                }
                if (color == DyeColor.WHITE) break block5;
                ((List)outputs.get(0)).set(0, IDyeableItem.colorStack((ItemStack)((ItemStack)((List)outputs.get(0)).get(0)), Arrays.asList(color)));
                break block5;
            }
            for (int index = 0; index < inputs.size(); ++index) {
                List list = (List)inputs.get(index);
                if (!list.stream().allMatch(stack -> ItemTags.field_199904_a.func_199685_a_((Object)stack.func_77973_b()))) continue;
                inputs.set(index, Arrays.asList(new ItemStack((IItemProvider)Blocks.field_196556_aL)));
            }
        }
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.getSize().width, this.getSize().height);
        guiItemStacks.set(0, (List)outputs.get(0));
    }
}

