/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core.registry.other;

import com.farcr.savageandravage.common.advancement.SRTriggers;
import com.farcr.savageandravage.common.effect.GrowingEffect;
import com.farcr.savageandravage.common.effect.ShrinkingEffect;
import com.farcr.savageandravage.common.entity.BurningBannerEntity;
import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.common.entity.GrieferEntity;
import com.farcr.savageandravage.common.entity.IOwnableMob;
import com.farcr.savageandravage.common.entity.SkeletonVillagerEntity;
import com.farcr.savageandravage.common.entity.goals.ImprovedCrossbowGoal;
import com.farcr.savageandravage.core.registry.SREntities;
import com.farcr.savageandravage.core.registry.SRItems;
import com.farcr.savageandravage.core.registry.SRSounds;
import com.farcr.savageandravage.core.registry.other.SRConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="savageandravage")
public class SREvents {
    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PillagerEntity) {
            PillagerEntity pillager = (PillagerEntity)event.getEntity();
            ImprovedCrossbowGoal<PillagerEntity> aiCrossBow = new ImprovedCrossbowGoal<PillagerEntity>(pillager, 1.0, 8.0f, 5.0);
            pillager.field_70714_bg.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof RangedCrossbowAttackGoal).findFirst().ifPresent(crossbowGoal -> {
                pillager.field_70714_bg.func_85156_a(crossbowGoal);
                pillager.field_70714_bg.func_75776_a(3, (Goal)aiCrossBow);
            });
            if (event.getWorld().field_73012_v.nextInt(100) == 0 && !event.getWorld().field_72995_K) {
                pillager.func_184201_a(EquipmentSlotType.OFFHAND, SREvents.createRocket());
                pillager.func_184598_c(Hand.OFF_HAND);
                pillager.func_184642_a(EquipmentSlotType.OFFHAND, 2.0f);
            }
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, SkeletonVillagerEntity.class, 15.0f, 1.0, 1.0));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, GrieferEntity.class, 15.0f, 0.7, 0.7));
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        PillagerEntity pillager;
        if (event.getEntity() instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)event.getEntity();
            if (event.getSource().func_94541_c() && SRConfig.CreepersSpawnSporesAfterDeathByBoom) {
                creeper.func_199701_a_(new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get(), 1 + creeper.field_70170_p.field_73012_v.nextInt(5)));
            }
        } else if (event.getEntity() instanceof PillagerEntity && (pillager = (PillagerEntity)event.getEntity()).func_70613_aW() && ((ServerWorld)pillager.func_130014_f_()).func_217475_c_(pillager.func_180425_c()) != null) {
            pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, pillager.field_70170_p.field_73012_v.nextInt(2)));
            if (pillager.field_70170_p.field_73012_v.nextDouble() < 0.05) {
                pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, 4 + pillager.field_70170_p.field_73012_v.nextInt(1)));
            }
            if (pillager.field_70170_p.field_73012_v.nextDouble() < 0.12) {
                pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, 2 + pillager.field_70170_p.field_73012_v.nextInt(1)));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof GolemEntity && !(event.getEntityLiving() instanceof ShulkerEntity) && event.getTarget() instanceof IOwnableMob && ((IOwnableMob)event.getTarget()).getOwner() instanceof PlayerEntity && ((MobEntity)event.getTarget()).func_70638_az() != event.getEntityLiving()) {
            ((GolemEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getExplosion().func_94613_c() instanceof CreeperEntity && !(event.getExplosion().func_94613_c() instanceof CreepieEntity)) {
            CreeperEntity creeper = (CreeperEntity)event.getExplosion().func_94613_c();
            if (SRConfig.CreeperNoDestroyBlocks) {
                event.getAffectedBlocks().clear();
            }
            CreeperSporeCloudEntity spores = new CreeperSporeCloudEntity((EntityType<? extends CreeperSporeCloudEntity>)((EntityType)SREntities.CREEPER_SPORE_CLOUD.get()), event.getWorld());
            if (SRConfig.CreepersSpawnCreepiesWhenBoom) {
                spores.cloudSize = creeper.func_225509_J__() ? (int)(creeper.func_110143_aJ() / 2.0f) : (int)(creeper.func_110143_aJ() / 5.0f);
                spores.func_82149_j((Entity)creeper);
                creeper.field_70170_p.func_217376_c((Entity)spores);
            }
        }
    }

    @SubscribeEvent
    public static void handleBlastProof(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float decrease = 0.0f;
        boolean flag = false;
        ItemStack head = entity.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = entity.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = entity.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = entity.func_184582_a(EquipmentSlotType.FEET);
        if (event.getSource().func_94541_c()) {
            if (head.func_77973_b() == SRItems.GRIEFER_HELMET.get()) {
                decrease += 0.25f;
                flag = true;
                SREvents.blastProtect(head, event.getEntityLiving());
            }
            if (chest.func_77973_b() == SRItems.GRIEFER_CHESTPLATE.get()) {
                decrease += 0.3f;
                flag = true;
                SREvents.blastProtect(chest, event.getEntityLiving());
            }
            if (legs.func_77973_b() == SRItems.GRIEFER_LEGGINGS.get()) {
                decrease += 0.25f;
                flag = true;
                SREvents.blastProtect(legs, event.getEntityLiving());
            }
            if (feet.func_77973_b() == SRItems.GRIEFER_BOOTS.get()) {
                decrease += 0.2f;
                flag = true;
                SREvents.blastProtect(feet, event.getEntityLiving());
            }
            if (flag) {
                event.setAmount(event.getAmount() - event.getAmount() * decrease);
            }
        }
    }

    public static void blastProtect(ItemStack stack, LivingEntity entity) {
        int damage = 22;
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)stack) > 0) {
            damage -= EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)stack) * 8;
        }
        stack.func_222118_a(damage, entity, onBroken -> onBroken.func_213361_c(EquipmentSlotType.CHEST));
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Item heldItem = event.getItemStack().func_77973_b();
        Entity target = event.getTarget();
        if (target instanceof CreeperEntity && heldItem == Items.field_196167_cx) {
            CreepieEntity creepieEntity = new CreepieEntity((EntityType<? extends CreepieEntity>)((EntityType)SREntities.CREEPIE.get()), event.getWorld());
            creepieEntity.func_82149_j(target);
            if (event.getItemStack().func_82837_s()) {
                creepieEntity.func_200203_b(event.getItemStack().func_200301_q());
            }
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_184609_a(event.getHand());
            event.getWorld().func_217376_c((Entity)creepieEntity);
        }
    }

    @SubscribeEvent
    public static void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItemStack = event.getItemStack();
        Item heldItem = event.getItemStack().func_77973_b();
        PlayerEntity player = event.getPlayer();
        BlockPos blockPos = event.getPos();
        ResourceLocation pot = new ResourceLocation("savageandravage:potted_" + heldItem.getRegistryName().func_110623_a());
        if (event.getWorld().func_180495_p(blockPos).func_177230_c() == Blocks.field_150457_bL && ForgeRegistries.BLOCKS.containsKey(pot)) {
            event.getWorld().func_175656_a(blockPos, ((Block)ForgeRegistries.BLOCKS.getValue(pot)).func_176223_P());
            event.getPlayer().func_184609_a(event.getHand());
            player.func_195066_a(Stats.field_188088_V);
            if (!event.getPlayer().field_71075_bZ.field_75098_d) {
                heldItemStack.func_190918_g(1);
            }
        }
        if (event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof AbstractBannerBlock && event.getWorld().func_217357_a(BurningBannerEntity.class, new AxisAlignedBB(blockPos)).isEmpty()) {
            TileEntity te = event.getWorld().func_175625_s(blockPos);
            boolean isFlintAndSteel = heldItem instanceof FlintAndSteelItem;
            boolean isFireCharge = heldItem instanceof FireChargeItem;
            if (isFlintAndSteel || isFireCharge) {
                TranslationTextComponent bannerName;
                BannerTileEntity banner = (BannerTileEntity)te;
                try {
                    bannerName = (TranslationTextComponent)banner.func_200200_C_();
                }
                catch (ClassCastException cast) {
                    bannerName = null;
                }
                if (bannerName.func_150268_i().contains("block.minecraft.ominous_banner")) {
                    if (isFlintAndSteel) {
                        event.getWorld().func_184133_a(player, blockPos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                        player.func_184609_a(event.getHand());
                        if (player instanceof ServerPlayerEntity) {
                            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockPos, heldItemStack);
                            heldItemStack.func_222118_a(1, (LivingEntity)player, p_219998_1_ -> p_219998_1_.func_213334_d(event.getHand()));
                        }
                    }
                    if (isFireCharge && !event.getWorld().func_180495_p(blockPos.func_177972_a(event.getFace())).func_196958_f()) {
                        event.getWorld().func_184133_a(player, blockPos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (new Random().nextFloat() - new Random().nextFloat()) * 0.2f + 1.0f);
                        player.func_184609_a(event.getHand());
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItemStack.func_190918_g(1);
                        }
                    }
                    if (player instanceof ServerPlayerEntity) {
                        SRTriggers.BURN_BANNER.trigger((ServerPlayerEntity)player);
                    }
                    if (!event.getWorld().field_72995_K) {
                        ServerWorld server = (ServerWorld)event.getWorld();
                        if (server.func_217475_c_(blockPos) == null) {
                            EffectInstance badOmenOnPlayer = event.getPlayer().func_70660_b(Effects.field_220309_E);
                            int i = 1;
                            if (badOmenOnPlayer != null) {
                                i += badOmenOnPlayer.func_76458_c();
                                event.getPlayer().func_184596_c(Effects.field_220309_E);
                            } else {
                                --i;
                            }
                            i = MathHelper.func_76125_a((int)i, (int)0, (int)5);
                            EffectInstance effectinstance = new EffectInstance(Effects.field_220309_E, 120000, i, false, false, true);
                            if (!event.getWorld().func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                                event.getPlayer().func_195064_c(effectinstance);
                            }
                        }
                        event.getWorld().func_217376_c((Entity)new BurningBannerEntity(event.getWorld(), blockPos));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPotionExpire(PotionEvent.PotionExpiryEvent event) throws InvocationTargetException, IllegalAccessException {
        LivingEntity affected = event.getEntityLiving();
        boolean shouldSetChild = false;
        int growingAgeValue = 0;
        if (event.getPotionEffect().func_188419_a() instanceof ShrinkingEffect) {
            shouldSetChild = true;
            growingAgeValue = -24000;
        }
        if (event.getPotionEffect().func_188419_a() instanceof GrowingEffect || shouldSetChild) {
            boolean canChange = false;
            if (affected instanceof SlimeEntity) {
                SlimeEntity slime = (SlimeEntity)affected;
                int size = slime.func_70809_q();
                if (shouldSetChild ? size > 1 : size < 3) {
                    canChange = true;
                    Method setSize = ObfuscationReflectionHelper.findMethod(SlimeEntity.class, (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
                    Object[] objectArray = new Object[2];
                    objectArray[0] = size + (shouldSetChild ? (size < 4 ? -1 : -2) : (size < 2 ? 1 : 2));
                    objectArray[1] = false;
                    setSize.invoke((Object)slime, objectArray);
                }
            } else if (SREvents.checkBooflo(affected, shouldSetChild)) {
                canChange = true;
            } else if (shouldSetChild != affected.func_70631_g_()) {
                canChange = true;
                if (affected instanceof AgeableEntity && !(affected instanceof ParrotEntity)) {
                    ((AgeableEntity)affected).func_70873_a(growingAgeValue);
                } else if (shouldSetChild && affected instanceof CreeperEntity) {
                    SREvents.convertCreeper((CreeperEntity)affected);
                } else if (!shouldSetChild && affected instanceof CreepieEntity) {
                    ((CreepieEntity)affected).setGrowingAge(growingAgeValue);
                } else if (affected instanceof ZombieEntity) {
                    ((ZombieEntity)affected).func_82227_f(shouldSetChild);
                } else {
                    canChange = false;
                }
            }
            if (!canChange) {
                if (!shouldSetChild) {
                    affected.func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 0));
                }
                if (affected.func_70662_br()) {
                    shouldSetChild = !shouldSetChild;
                }
                EffectInstance effectInstance = new EffectInstance(shouldSetChild ? Effects.field_76433_i : Effects.field_76432_h, 1, 1);
                effectInstance.func_188419_a().func_180793_a(null, null, affected, effectInstance.func_76458_c(), 1.0);
            }
            if (affected.func_70613_aW()) {
                ((ServerWorld)affected.field_70170_p).func_195598_a((IParticleData)(canChange ? (shouldSetChild ? ParticleTypes.field_197604_O : ParticleTypes.field_197632_y) : ParticleTypes.field_197594_E), affected.func_226282_d_(0.3), affected.func_226279_cv_() - 0.1, affected.func_226287_g_(0.3), canChange ? 40 : 20, 0.3, 0.6, 0.3, canChange ? 0.2 : 0.01);
                affected.func_184185_a(canChange ? (SoundEvent)SRSounds.GROWTH_MODIFICATION_SUCCESS.get() : (SoundEvent)SRSounds.GROWTH_MODIFICATION_FAILURE.get(), 1.0f, 1.0f);
            }
        }
    }

    public static boolean checkBooflo(LivingEntity affected, boolean isBabyPotion) {
        if (ModList.get().isLoaded("endergetic")) {
            return !isBabyPotion && affected.func_200600_R() == ForgeRegistries.ENTITIES.getValue(new ResourceLocation("endergetic:booflo_baby")) || affected.func_200600_R() == ForgeRegistries.ENTITIES.getValue(new ResourceLocation("endergetic:booflo_adolescent")) || isBabyPotion && affected.func_200600_R() == ForgeRegistries.ENTITIES.getValue(new ResourceLocation("endergetic:booflo"));
        }
        return false;
    }

    public static void convertCreeper(CreeperEntity creeper) {
        CreepieEntity creepie = (CreepieEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a(creeper.field_70170_p);
        creepie.func_82149_j(creeper.getEntity());
        creepie.func_213386_a((IWorld)creeper.field_70170_p, creeper.field_70170_p.func_175649_E(new BlockPos((Entity)creepie)), SpawnReason.CONVERSION, null, null);
        creeper.func_70106_y();
        creepie.func_94061_f(creeper.func_175446_cd());
        if (creeper.func_145818_k_()) {
            creepie.func_200203_b(creeper.func_200201_e());
            creepie.func_174805_g(creeper.func_174833_aM());
        }
        if (creeper.func_104002_bU()) {
            creepie.func_110163_bv();
        }
        if (creeper.func_110167_bD()) {
            creepie.func_110162_b(creeper.func_110166_bE(), true);
            creeper.func_110160_i(true, false);
        }
        if (creeper.func_184187_bx() != null) {
            creepie.func_184220_m(creeper.func_184187_bx());
        }
        creepie.func_184224_h(creeper.func_190530_aW());
        creeper.func_70606_j(creeper.func_110138_aP());
        creeper.field_70170_p.func_217376_c((Entity)creepie);
    }

    public static ItemStack createRocket() {
        ItemStack rocket = new ItemStack((IItemProvider)Items.field_196152_dE);
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = star.func_190925_c("Explosion");
        compoundnbt.func_74768_a("Type", FireworkRocketItem.Shape.BURST.func_196071_a());
        CompoundNBT compoundnbt1 = rocket.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        CompoundNBT compoundnbt2 = star.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return rocket;
    }
}

