/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.common.entity;

import com.farcr.savageandravage.common.block.RunedGloomyTilesBlock;
import com.farcr.savageandravage.common.entity.BurningBannerEntity;
import com.farcr.savageandravage.core.registry.SRBlocks;
import com.farcr.savageandravage.core.registry.SREntities;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RunePrisonEntity
extends Entity {
    private static final DataParameter<Integer> TICKS_TILL_REMOVE = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> BLOCK_POS = EntityDataManager.func_187226_a(BurningBannerEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private int currentFrame = 0;
    private boolean isBackwardsFrameCycle = false;

    public RunePrisonEntity(EntityType<? extends RunePrisonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public RunePrisonEntity(World worldIn, BlockPos positionIn, int ticksTillRemove) {
        super((EntityType)SREntities.RUNE_PRISON.get(), worldIn);
        this.setBlockPos(positionIn);
        this.setTicksTillRemove(ticksTillRemove);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BLOCK_POS, Optional.empty());
        this.field_70180_af.func_187214_a(TICKS_TILL_REMOVE, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setTicksTillRemove(compound.func_74762_e("TicksTillRemove"));
        if (compound.func_150297_b("GloomyTilePosition", 10)) {
            this.setBlockPos(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("GloomyTilePosition")));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBlockPos() != null) {
            compound.func_218657_a("GloomyTilePosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBlockPos()));
        }
    }

    public int getTicksTillRemove() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.field_70180_af.func_187227_b(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBlockPos() {
        return ((Optional)this.field_70180_af.func_187225_a(BLOCK_POS)).orElse(null);
    }

    private void setBlockPos(@Nullable BlockPos positionIn) {
        this.field_70180_af.func_187227_b(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    public void func_70071_h_() {
        List intersectingEntityList;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getTicksTillRemove() % 5 == 0) {
            if (!this.isBackwardsFrameCycle) {
                ++this.currentFrame;
                if (this.currentFrame == 4) {
                    this.isBackwardsFrameCycle = true;
                }
            } else {
                --this.currentFrame;
                if (this.currentFrame == 0) {
                    this.isBackwardsFrameCycle = false;
                }
            }
        }
        if (this.getTicksTillRemove() > 0) {
            this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        }
        if (!(intersectingEntityList = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ())).isEmpty()) {
            for (LivingEntity livingentity : intersectingEntityList) {
                if (!livingentity.func_184603_cC() || EntityTypeTags.field_219765_b.func_199685_a_((Object)livingentity.func_200600_R())) continue;
                livingentity.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2));
            }
        }
        if (this.getTicksTillRemove() == 0) {
            try {
                if (this.field_70170_p.func_180495_p(this.getBlockPos()).func_177230_c() instanceof RunedGloomyTilesBlock) {
                    this.field_70170_p.func_175656_a(this.getBlockPos(), ((Block)SRBlocks.GLOOMY_TILES.get()).func_176223_P());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.func_70106_y();
        }
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

