/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.common.entity;

import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.common.item.CreeperSporesItem;
import com.farcr.savageandravage.core.registry.SRItems;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GrieferEntity
extends AbstractIllagerEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> KICKING = EntityDataManager.func_187226_a(GrieferEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> APESHIT_MODE = EntityDataManager.func_187226_a(GrieferEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final EntityPredicate social_distance = new EntityPredicate().func_221013_a(10.0);
    public int kickTicks;
    public int creeperSporeStacks;

    public GrieferEntity(EntityType<? extends GrieferEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AbstractRaiderEntity.FindTargetGoal((AbstractRaiderEntity)this, (AbstractIllagerEntity)this, 10.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleePhaseGoal(this, 0.9, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new GrieferAttackWithSporesGoal(this, 1.0, 100));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true){

            public boolean func_75250_a() {
                return !(this.field_75441_b.func_184614_ca().func_77973_b() instanceof CreeperSporesItem) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 15.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(KICKING, (Object)false);
        this.field_70180_af.func_187214_a(APESHIT_MODE, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219686_is;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219689_iv;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SRItems.GRIEFER_SPAWN_EGG.get());
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219687_it;
    }

    public void func_70636_d() {
        if (this.kickTicks > 0) {
            ++this.kickTicks;
            LivingEntity attacker = this.func_70638_az();
            if (this.kickTicks == 10 && attacker != null && this.isKicking()) {
                this.func_70652_k((Entity)attacker);
                attacker.func_70653_a((Entity)this, 1.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                if (this.kickTicks < 10) {
                    this.setKicking(false);
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (this.isApeshit() && this.creeperSporeStacks <= 0 && damageSrc.func_76346_g() == this.func_70638_az() && this.func_70638_az() != null) {
            this.creeperSporeStacks = (int)this.field_110153_bc / 2;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.kickTicks = compound.func_74762_e("KickTicks");
        if (compound.func_150297_b("CreeperSporeStacks", 99)) {
            this.creeperSporeStacks = compound.func_74762_e("CreeperSporeStacks");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("KickTicks", this.kickTicks);
        compound.func_74768_a("CreeperSporeStacks", this.creeperSporeStacks);
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public void kick(double distance, LivingEntity entity) {
        if ((double)this.func_70032_d((Entity)entity) <= distance) {
            this.setKicking(true);
            this.func_70625_a((Entity)entity, 30.0f, 30.0f);
            this.kickTicks = 9;
        } else if ((double)this.func_70032_d((Entity)entity) > distance) {
            this.setKicking(false);
        }
    }

    public boolean isKicking() {
        return (Boolean)this.field_70180_af.func_187225_a(KICKING);
    }

    public boolean isApeshit() {
        return (Boolean)this.field_70180_af.func_187225_a(APESHIT_MODE);
    }

    public void setKicking(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(KICKING, (Object)p_213671_1_);
    }

    public void becomeApeshit(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(APESHIT_MODE, (Object)p_213671_1_);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        if (this.func_213630_eb()) {
            this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)SRItems.GRIEFER_CHESTPLATE.get()));
        }
        this.creeperSporeStacks = 10;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get()));
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.field_70170_p.func_217374_a(CreepieEntity.class, this.social_distance, (LivingEntity)this, this.func_174813_aQ().func_186662_g(30.0)).size() < 5 && this.func_184614_ca().func_77973_b() instanceof CreeperSporesItem) {
            CreeperSporeCloudEntity creeperSpores = new CreeperSporeCloudEntity(this.field_70170_p, (LivingEntity)this);
            double d0 = target.func_226280_cw_() - (double)1.1f;
            double d1 = target.func_226277_ct_() - this.func_226277_ct_();
            double d2 = d0 - creeperSpores.func_226278_cu_();
            double d3 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
            creeperSpores.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 12.0f);
            creeperSpores.cloudSize = creeperSpores.field_70170_p.field_73012_v.nextInt(50) == 0 ? 0 : 1 + creeperSpores.field_70170_p.field_73012_v.nextInt(3);
            this.func_184609_a(this.func_184600_cs());
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)creeperSpores);
            this.func_70625_a((Entity)target, 30.0f, 30.0f);
            --this.creeperSporeStacks;
        }
    }

    public static class GrieferAttackWithSporesGoal
    extends Goal {
        private final GrieferEntity griefer;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int seeTime;

        public GrieferAttackWithSporesGoal(GrieferEntity attacker, double movespeed, int maxAttackTime) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime);
        }

        public GrieferAttackWithSporesGoal(GrieferEntity attacker, double movespeed, int p_i1650_4_, int maxAttackTime) {
            this.griefer = attacker;
            this.entityMoveSpeed = movespeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = 15.0f;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.griefer.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.griefer.creeperSporeStacks > 0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.griefer.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            if (this.griefer.isApeshit()) {
                this.griefer.becomeApeshit(false);
            }
            if (this.griefer.creeperSporeStacks > 0) {
                this.griefer.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get()));
            }
        }

        public void func_75251_c() {
            this.griefer.func_213395_q(false);
            this.griefer.func_70624_b(null);
            this.rangedAttackTime = -1;
            if (this.griefer.isKicking()) {
                this.griefer.setKicking(false);
            }
        }

        public void func_75246_d() {
            LivingEntity attackTarget = this.griefer.func_70638_az();
            if (attackTarget != null) {
                double d0 = this.griefer.func_70032_d((Entity)attackTarget);
                boolean flag = this.griefer.func_70635_at().func_75522_a((Entity)attackTarget);
                this.griefer.func_213395_q(true);
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (this.griefer.func_70681_au().nextDouble() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.griefer.func_70681_au().nextDouble() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.griefer.kick(2.5, attackTarget);
                if (!(d0 > 15.0)) {
                    this.griefer.func_70661_as().func_75499_g();
                } else {
                    this.griefer.func_70661_as().func_75497_a((Entity)attackTarget, this.entityMoveSpeed);
                }
                this.griefer.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
                if (--this.rangedAttackTime == 0 || this.seeTime == 3) {
                    if (!flag) {
                        return;
                    }
                    float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                    float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                    this.griefer.func_82196_d(attackTarget, lvt_5_1_);
                    this.griefer.func_70625_a((Entity)attackTarget, 30.0f, 30.0f);
                    this.griefer.func_70605_aq().func_188488_a((float)(this.strafingBackwards ? -this.entityMoveSpeed : this.entityMoveSpeed), (float)(this.strafingClockwise ? this.entityMoveSpeed : -this.entityMoveSpeed));
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                } else if (this.rangedAttackTime < 0) {
                    float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
                }
            }
        }
    }

    public static class MeleePhaseGoal
    extends MeleeAttackGoal {
        private final GrieferEntity griefer;

        public MeleePhaseGoal(GrieferEntity griefer, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)griefer, speedIn, useLongMemory);
            this.griefer = griefer;
        }

        public boolean func_75250_a() {
            return this.griefer.creeperSporeStacks == 0 && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.griefer.creeperSporeStacks == 0 && super.func_75253_b();
        }

        public void func_75249_e() {
            this.griefer.becomeApeshit(true);
            if (this.griefer.creeperSporeStacks == 0) {
                this.griefer.func_184611_a(this.griefer.func_184600_cs(), ItemStack.field_190927_a);
            }
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (this.griefer.isKicking()) {
                this.griefer.setKicking(false);
            }
        }

        public void func_75246_d() {
            super.func_75246_d();
            if ((double)this.griefer.func_70032_d((Entity)this.griefer.func_70638_az()) > 2.0) {
                this.griefer.setKicking(false);
            }
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            int i = this.griefer.field_70170_p.field_73012_v.nextInt(3);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 60;
                switch (i) {
                    case 0: {
                        this.griefer.func_184609_a(Hand.MAIN_HAND);
                        break;
                    }
                    case 1: {
                        this.griefer.func_184609_a(Hand.OFF_HAND);
                        break;
                    }
                    case 2: {
                        this.griefer.kick(2.0, enemy);
                    }
                }
                this.griefer.func_70625_a((Entity)enemy, 30.0f, 30.0f);
                this.griefer.func_70652_k((Entity)enemy);
                enemy.func_70653_a((Entity)enemy, 1.5f, (double)MathHelper.func_76126_a((float)(this.griefer.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.griefer.field_70177_z * ((float)Math.PI / 180)))));
            }
        }
    }
}

