/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.crafting.DynamicRecipeManager;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.ReprocessorCrafting")
@ZenRegister
public class ReprocessorCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IItemStack output, final IIngredient input) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                ReprocessorRecipe recipe = new ReprocessorRecipe(new ResourceLocation("crafttweaker", id), input.asVanillaIngredient(), output.getInternal());
                DynamicRecipeManager.getRecipeManager().field_199522_d.computeIfAbsent(RecipeTypes.REPROCESSOR, t -> new HashMap()).put(recipe.func_199560_c(), recipe);
            }

            public String describe() {
                return "Adding Reprocessor Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)DynamicRecipeManager.getRecipeManager().field_199522_d.getOrDefault(RecipeTypes.REPROCESSOR, new HashMap())).values().stream().filter(r -> r.func_77571_b().func_77969_a(stack.getInternal())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)DynamicRecipeManager.getRecipeManager().field_199522_d.get(RecipeTypes.REPROCESSOR)).remove(r));
            }

            public String describe() {
                return "Removing Reprocessor Crafting recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }
}

