/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.plugin.hwyla;

import com.mojang.datafixers.util.Either;
import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import snownee.fruits.FruitType;
import snownee.fruits.Hook;
import snownee.fruits.plugin.hwyla.HwylaPlugin;
import snownee.kiwi.util.NBTHelper;

public class BeePollenProvider
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final BeePollenProvider INSTANCE = new BeePollenProvider();

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.get(HwylaPlugin.BEE) || !(accessor.getEntity() instanceof BeeEntity)) {
            return;
        }
        CompoundNBT data = accessor.getServerData();
        if (!data.func_74764_b("pollen")) {
            return;
        }
        ListNBT list = data.func_150295_c("pollen", 8);
        List<Either<FruitType, Block>> pollen = Hook.readPollen(list);
        RenderableTextComponent[] components = new RenderableTextComponent[pollen.size()];
        int i = 0;
        for (Either<FruitType, Block> e : pollen) {
            components[i] = (RenderableTextComponent)e.map(type -> HwylaPlugin.item(new ItemStack((IItemProvider)type.fruit)), block -> HwylaPlugin.item(new ItemStack((IItemProvider)block)));
            ++i;
        }
        tooltip.add((ITextComponent)new RenderableTextComponent(components));
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, Entity entity) {
        NBTHelper data;
        ListNBT list;
        if (entity instanceof BeeEntity && (list = (data = NBTHelper.of((CompoundNBT)entity.getPersistentData())).getTagList("FruitsList", 8)) != null) {
            tag.func_218657_a("pollen", (INBT)list);
        }
    }
}

